/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.client;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.scheduler.server.client.SchedulerClient;
import fr.gouv.vitam.scheduler.server.client.SchedulerClientRest;
import java.io.File;
import java.io.IOException;

public class SchedulerClientFactory
extends VitamClientFactory<SchedulerClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SchedulerClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "scheduler-client.conf";
    private static final String RESOURCE_PATH = "/scheduler/v1";
    private static final SchedulerClientFactory META_DATA_CLIENT_FACTORY = new SchedulerClientFactory();

    private SchedulerClientFactory() {
        super(SchedulerClientFactory.changeConfigurationFile(), RESOURCE_PATH, false);
    }

    static ClientConfiguration changeConfigurationFile() {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)CONFIGURATION_FILENAME), ClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME);
        }
        return configuration;
    }

    public static void changeMode(ClientConfiguration configuration) {
        SchedulerClientFactory.getInstance().initialisation(configuration, SchedulerClientFactory.getInstance().getResourcePath());
    }

    public static SchedulerClientFactory getInstance() {
        return META_DATA_CLIENT_FACTORY;
    }

    public SchedulerClient getClient() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Actually only one client implementation exists, so ignore client type value");
        }
        return switch (this.getVitamClientType()) {
            case VitamClientFactoryInterface.VitamClientType.MOCK -> throw new IllegalArgumentException("Not implemented");
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new SchedulerClientRest((VitamClientFactoryInterface<?>)this);
            default -> throw new IllegalArgumentException("Scheduler type unknown");
        };
    }
}

