/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.operations.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.database.parameter.SwitchIndexParameters;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.logbook.common.client.ErrorMessage;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.model.AuditLogbookOptions;
import fr.gouv.vitam.logbook.common.model.LifecycleTraceabilityStatus;
import fr.gouv.vitam.logbook.common.model.TenantLogbookOperationTraceabilityResult;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookCheckResult;
import fr.gouv.vitam.logbook.common.model.reconstruction.ReconstructionRequestItem;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationsClientHelper;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

class LogbookOperationsClientRest
extends DefaultClient
implements LogbookOperationsClient {
    private static final String OPERATIONS_URL = "/operations";
    private final String RECONSTRUCTION_OPERATIONS_URI = "/reconstruction/operations";

    LogbookOperationsClientRest(LogbookOperationsClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public void create(LogbookOperationParameters ... parameters) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        if (parameters.length == 0) {
            return;
        }
        String eip = LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)parameters[0]);
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/operations/" + eip).withBody((Object)parameters).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public void update(LogbookOperationParameters ... parameters) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        if (parameters.length == 0) {
            return;
        }
        String eip = LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)parameters[0]);
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/operations/" + eip).withBody((Object)parameters).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException | LogbookClientAlreadyExistsException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public JsonNode selectOperation(JsonNode select) throws LogbookClientException, InvalidParseOperationException {
        return this.selectOperation(select, false, false);
    }

    @Override
    public JsonNode selectOperation(JsonNode select, boolean isSliced, boolean isCrossTenant) throws LogbookClientException, InvalidParseOperationException {
        JsonNode jsonNode;
        block10: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(OPERATIONS_URL).withBody((Object)select).withJson();
            if (isSliced) {
                request.withHeader("X-Sliced-Operations", (Object)true);
            }
            if (isCrossTenant) {
                request.withHeader("X-Cross-Tenant", (Object)true);
            }
            Response response = this.make(request);
            try {
                this.check(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode selectOperationById(String processId, JsonNode query, boolean isSliced, boolean isCrossTenant) throws LogbookClientException, InvalidParseOperationException {
        JsonNode jsonNode;
        block10: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/operations/" + processId).withBody((Object)query).withContentType(MediaType.APPLICATION_JSON_TYPE).withJsonAccept();
            if (isSliced) {
                request.withHeader("X-Sliced-Operations", (Object)true);
            }
            if (isCrossTenant) {
                request.withHeader("X-Cross-Tenant", (Object)true);
            }
            Response response = this.make(request);
            try {
                this.check(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode selectOperationById(String processId) throws LogbookClientException, InvalidParseOperationException {
        return this.selectOperationById(processId, (JsonNode)new Select().getFinalSelect(), false, false);
    }

    @Override
    public void create(String eventIdProc, Iterable<LogbookOperationParameters> queue) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        LogbookOperationParameters[] parameters = (LogbookOperationParameters[])StreamSupport.stream(queue.spliterator(), false).toArray(LogbookOperationParameters[]::new);
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/operations/" + eventIdProc).withBody((Object)parameters).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public void update(String eventIdProc, Iterable<LogbookOperationParameters> queue) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        LogbookOperationParameters[] parameters = (LogbookOperationParameters[])StreamSupport.stream(queue.spliterator(), false).toArray(LogbookOperationParameters[]::new);
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/operations/" + eventIdProc).withBody((Object)parameters).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException | LogbookClientAlreadyExistsException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public RequestResponseOK<TenantLogbookOperationTraceabilityResult> traceability(List<Integer> tenants) throws LogbookClientServerException, InvalidParseOperationException {
        RequestResponseOK requestResponseOK;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath("/operations/traceability").withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter()).withBody((Object)JsonHandler.toJsonNode(tenants)).withJson());
            try {
                this.check(response);
                RequestResponse result = RequestResponse.parseFromResponse((Response)response, TenantLogbookOperationTraceabilityResult.class);
                requestResponseOK = (RequestResponseOK)result;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponseOK<String> traceabilityLfcUnit() throws LogbookClientServerException, InvalidParseOperationException {
        return this.traceabilityLFC("/lifecycles/units/traceability");
    }

    @Override
    public RequestResponseOK<String> traceabilityLfcObjectGroup() throws LogbookClientServerException, InvalidParseOperationException {
        return this.traceabilityLFC("/lifecycles/objectgroups/traceability");
    }

    private RequestResponseOK<String> traceabilityLFC(String traceabilityUri) throws LogbookClientServerException, InvalidParseOperationException {
        RequestResponseOK requestResponseOK;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath(traceabilityUri).withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter()).withJsonAccept());
            try {
                this.check(response);
                requestResponseOK = RequestResponse.parseRequestResponseOk((Response)response, String.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public LifecycleTraceabilityStatus checkLifecycleTraceabilityWorkflowStatus(String operationId) throws LogbookClientServerException, InvalidParseOperationException {
        LifecycleTraceabilityStatus lifecycleTraceabilityStatus;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath("/lifecycles/traceability/check/" + operationId).withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter()).withJsonAccept());
            try {
                this.check(response);
                JsonNode jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                RequestResponseOK requestResponse = RequestResponseOK.getFromJsonNode((JsonNode)jsonNode, LifecycleTraceabilityStatus.class);
                lifecycleTraceabilityStatus = (LifecycleTraceabilityStatus)requestResponse.getFirstResult();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return lifecycleTraceabilityStatus;
    }

    @Override
    public ReindexationResult reindex(IndexParameters indexParam) throws InvalidParseOperationException, LogbookClientServerException {
        ReindexationResult reindexationResult;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath("/reindex").withBody((Object)indexParam, "The options are mandatory").withJson());
            try {
                this.check(response);
                reindexationResult = (ReindexationResult)response.readEntity(ReindexationResult.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return reindexationResult;
    }

    @Override
    public SwitchIndexResult switchIndexes(SwitchIndexParameters switchIndexParam) throws InvalidParseOperationException, LogbookClientServerException {
        SwitchIndexResult switchIndexResult;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath("/alias").withBody((Object)switchIndexParam, "The options are mandatory").withJson());
            try {
                this.check(response);
                switchIndexResult = (SwitchIndexResult)response.readEntity(SwitchIndexResult.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return switchIndexResult;
    }

    @Override
    public void traceabilityAudit(int tenant, AuditLogbookOptions options) throws LogbookClientServerException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/auditTraceability").withHeader("X-Tenant-Id", (Object)tenant).withBody((Object)options).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public LogbookCheckResult checkLogbookCoherence() throws LogbookClientServerException {
        LogbookCheckResult logbookCheckResult;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath("/checklogbook").withJson());
            try {
                this.check(response);
                JsonNode jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                logbookCheckResult = (LogbookCheckResult)JsonHandler.getFromJsonNode((JsonNode)jsonNode, LogbookCheckResult.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return logbookCheckResult;
    }

    private void check(Response response) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException, LogbookClientNotFoundException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        switch (status) {
            case CONFLICT: {
                throw new LogbookClientAlreadyExistsException(ErrorMessage.LOGBOOK_ALREADY_EXIST.getMessage());
            }
            case BAD_REQUEST: {
                throw new LogbookClientBadRequestException(ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
            }
            case NOT_FOUND: {
                throw new LogbookClientNotFoundException(ErrorMessage.LOGBOOK_NOT_FOUND.getMessage());
            }
        }
        throw new LogbookClientServerException(status.toString());
    }

    @Override
    public RequestResponse<JsonNode> getLastOperationByType(String operationType) throws LogbookClientServerException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath("/lastOperationByType").withBody((Object)operationType).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public void reconstructCollection(List<ReconstructionRequestItem> reconstructionItems) throws LogbookClientServerException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/reconstruction/operations").withBody(reconstructionItems).withJson());){
            this.check(response);
        }
        catch (VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }
}

