/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.operations.client;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientMock;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientRest;
import java.io.File;
import java.io.IOException;

public class LogbookOperationsClientFactory
extends VitamClientFactory<LogbookOperationsClient> {
    private static final String CONFIGURATION_FILENAME = "logbook-client.conf";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookOperationsClientFactory.class);
    private static final LogbookOperationsClientFactory LOGBOOK_CLIENT_FACTORY = new LogbookOperationsClientFactory();
    public static final String RESOURCE_PATH = "/logbook/v1";

    private LogbookOperationsClientFactory() {
        super(LogbookOperationsClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH, false);
    }

    public static final LogbookOperationsClientFactory getInstance() {
        return LOGBOOK_CLIENT_FACTORY;
    }

    public LogbookOperationsClient getClient() {
        return switch (this.getVitamClientType()) {
            case VitamClientFactoryInterface.VitamClientType.MOCK -> new LogbookOperationsClientMock();
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new LogbookOperationsClientRest(this);
            default -> throw new IllegalArgumentException("Log type unknown");
        };
    }

    static final ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), ClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        } else if (configuration.getServerHost() == null || configuration.getServerHost().trim().isEmpty() || configuration.getServerPort() <= 0) {
            configuration = null;
        }
        return configuration;
    }

    public static final void changeMode(ClientConfiguration configuration) {
        LogbookOperationsClientFactory.getInstance().initialisation(configuration, LogbookOperationsClientFactory.getInstance().getResourcePath());
    }
}

