/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.data.core;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.processing.Step;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.common.model.ProcessStep;
import fr.gouv.vitam.processing.common.model.ProcessWorkflow;
import fr.gouv.vitam.processing.data.core.ProcessDataAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ProcessDataAccessImpl
implements ProcessDataAccess {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessDataAccessImpl.class);
    private static final Map<Integer, Map<String, ProcessWorkflow>> WORKFLOWS_LIST = new ConcurrentHashMap<Integer, Map<String, ProcessWorkflow>>();
    private static final ProcessDataAccessImpl INSTANCE = new ProcessDataAccessImpl();
    private static final String PROCESS_DOES_NOT_EXIST = "Process does not exist";

    private ProcessDataAccessImpl() {
    }

    public static ProcessDataAccessImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public ProcessWorkflow initProcessWorkflow(WorkFlow workflow, String containerName) {
        ParametersChecker.checkParameter((String)"containerName is a mandatory parameter", (String[])new String[]{containerName});
        ParametersChecker.checkParameter((String)"workflow is a mandatory parameter", (Object[])new Object[]{workflow});
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String contextId = VitamThreadUtils.getVitamSession().getContextId();
        String applicationId = VitamThreadUtils.getVitamSession().getApplicationSessionId();
        ProcessWorkflow pwkf = new ProcessWorkflow();
        pwkf.setLogbookTypeProcess(LogbookTypeProcess.valueOf((String)workflow.getTypeProc()));
        pwkf.setOperationId(containerName);
        pwkf.setTenantId(tenantId);
        pwkf.setContextId(contextId);
        pwkf.setApplicationId(applicationId);
        int cpt = 0;
        for (Step step : workflow.getSteps()) {
            String uniqueId = containerName + "_" + workflow.getId() + "_" + cpt + "_" + step.getStepName();
            step.setId(uniqueId);
            pwkf.getSteps().add(new ProcessStep(step, containerName, workflow.getId(), cpt, new AtomicLong(0L), new AtomicLong(0L)));
            ++cpt;
        }
        this.addToWorkflowList(pwkf);
        return pwkf;
    }

    @Override
    public ProcessWorkflow findOneProcessWorkflow(String processId, Integer tenantId) throws WorkflowNotFoundException {
        ParametersChecker.checkParameter((String)"processId is a mandatory parameter", (String[])new String[]{processId});
        ParametersChecker.checkParameter((String)"tenantId is a mandatory parameter", (Object[])new Object[]{tenantId});
        if (!WORKFLOWS_LIST.containsKey(tenantId) || WORKFLOWS_LIST.get(tenantId) == null || !WORKFLOWS_LIST.get(tenantId).containsKey(processId)) {
            throw new WorkflowNotFoundException("Process does not exist > Tenant (" + tenantId + "). Process (" + processId + ") map = " + String.valueOf(WORKFLOWS_LIST.keySet()));
        }
        return WORKFLOWS_LIST.get(tenantId).get(processId);
    }

    @VisibleForTesting
    public void clearWorkflow() {
        WORKFLOWS_LIST.clear();
    }

    @Override
    public List<ProcessWorkflow> findAllProcessWorkflow(Integer tenantId) {
        return new ArrayList<ProcessWorkflow>(((Map)WORKFLOWS_LIST.getOrDefault(tenantId, new HashMap())).values());
    }

    @Override
    public void addToWorkflowList(ProcessWorkflow processWorkflow) {
        LOGGER.info("add workflow with processId: {} and tenant {}", (Object)processWorkflow.getOperationId(), (Object)processWorkflow.getTenantId());
        WORKFLOWS_LIST.computeIfAbsent(processWorkflow.getTenantId(), key -> new ConcurrentHashMap()).put(processWorkflow.getOperationId(), processWorkflow);
    }

    @Override
    public Map<Integer, Map<String, ProcessWorkflow>> getWorkFlowList() {
        return WORKFLOWS_LIST;
    }
}

