/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.server;

import com.mongodb.client.MongoClient;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.server.ElasticsearchAccessAdminFactory;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import java.util.ArrayList;
import java.util.List;

public final class MongoDbAccessAdminFactory {
    private MongoDbAccessAdminFactory() {
    }

    public static MongoDbAccessAdminImpl create(DbConfiguration configuration, OntologyLoader ontologyLoader, ElasticsearchFunctionalAdminIndexManager indexManager) {
        ParametersChecker.checkParameter((String)"configuration is a mandatory parameter", (Object[])new Object[]{configuration});
        ArrayList classList = new ArrayList();
        for (FunctionalAdminCollections e : (FunctionalAdminCollections[])FunctionalAdminCollections.class.getEnumConstants()) {
            classList.add(e.getClasz());
        }
        FunctionalAdminCollections.class.getEnumConstants();
        MongoClient mongoClient = MongoDbAccess.createMongoClient((DbConfiguration)configuration, classList);
        return new MongoDbAccessAdminImpl(mongoClient, configuration.getDbName(), false, indexManager, ontologyLoader);
    }

    public static MongoDbAccessAdminImpl create(DbConfiguration configuration, String clusterName, List<ElasticsearchNode> nodes, OntologyLoader ontologyLoader, ElasticsearchFunctionalAdminIndexManager indexManager) {
        ElasticsearchAccessAdminFactory.create(clusterName, nodes, indexManager);
        return MongoDbAccessAdminFactory.create(configuration, ontologyLoader, indexManager);
    }
}

