/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.server;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.server.ElasticsearchAccessFunctionalAdmin;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import java.util.Arrays;
import java.util.List;

public final class ElasticsearchAccessAdminFactory {
    private ElasticsearchAccessAdminFactory() {
    }

    public static final ElasticsearchAccessFunctionalAdmin create(AdminManagementConfiguration configuration, ElasticsearchFunctionalAdminIndexManager indexManager) {
        ParametersChecker.checkParameter((String)"configuration is a mandatory parameter", (Object[])new Object[]{configuration});
        return ElasticsearchAccessAdminFactory.create(configuration.getClusterName(), configuration.getElasticsearchNodes(), indexManager);
    }

    public static ElasticsearchAccessFunctionalAdmin create(String clusterName, List<ElasticsearchNode> nodes, ElasticsearchFunctionalAdminIndexManager indexManager) {
        ParametersChecker.checkParameter((String)"configuration is a mandatory parameter", (Object[])new Object[]{clusterName, nodes});
        try {
            ElasticsearchAccessFunctionalAdmin elasticsearchAccess = new ElasticsearchAccessFunctionalAdmin(clusterName, nodes, indexManager);
            Arrays.stream(FunctionalAdminCollections.values()).filter(collection -> collection != FunctionalAdminCollections.VITAM_SEQUENCE).forEach(collection -> collection.initialize(elasticsearchAccess));
            return elasticsearchAccess;
        }
        catch (VitamException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

