/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.config;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.common.model.config.CollectionConfigurationUtils;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.FunctionalAdminIndexationConfiguration;
import java.io.File;
import java.io.IOException;

public class AdminManagementConfigurationValidator {
    public static void validateConfiguration(AdminManagementConfiguration adminManagementConfiguration) {
        if (adminManagementConfiguration == null) {
            throw new IllegalStateException("Invalid configuration. Null config");
        }
        AdminManagementConfigurationValidator.validateIndexationConfiguration(adminManagementConfiguration.getIndexationConfiguration());
        try {
            AdminManagementConfigurationValidator.validateElasticsearchSettings(adminManagementConfiguration.getElasticsearchConfigurationFile());
        }
        catch (InvalidParseOperationException | IOException e) {
            throw new IllegalStateException("Invalid configuration.");
        }
    }

    private static void validateElasticsearchSettings(String elasticsearchConfigurationFilePath) throws IOException, InvalidParseOperationException {
        if (elasticsearchConfigurationFilePath == null) {
            throw new IllegalStateException("Invalid path of elasticsearch Configuration File. Null config");
        }
        File elasticsearchConfigurationFile = new File(elasticsearchConfigurationFilePath);
        SanityChecker.checkJsonFile((File)elasticsearchConfigurationFile);
        if (!elasticsearchConfigurationFile.exists() || !elasticsearchConfigurationFile.isFile()) {
            throw new IllegalStateException("Not found elasticsearch Configuration File in the provided path");
        }
    }

    private static void validateIndexationConfiguration(FunctionalAdminIndexationConfiguration indexationConfiguration) {
        if (indexationConfiguration == null) {
            throw new IllegalStateException("Invalid configuration. Missing ES tenant indexation");
        }
        if (indexationConfiguration.getDefaultConfiguration() == null) {
            throw new IllegalStateException("Invalid configuration. Missing default configuration");
        }
        CollectionConfigurationUtils.validate((CollectionConfiguration)indexationConfiguration.getDefaultConfiguration(), (boolean)false);
        for (CollectionConfiguration collectionConfiguration : indexationConfiguration.getCollectionConfigurationMap().values()) {
            CollectionConfigurationUtils.validate((CollectionConfiguration)collectionConfiguration, (boolean)true);
        }
    }
}

