/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.administration.RegisterValueDetailModel;
import org.bson.Document;

public class AccessionRegisterSummary
extends VitamDocument<AccessionRegisterSummary> {
    private static final long serialVersionUID = 3439757375656161919L;
    public static final String ORIGINATING_AGENCY = "OriginatingAgency";
    public static final String TOTAL_UNITS = "TotalUnits";
    public static final String TOTAL_OBJECTGROUPS = "TotalObjectGroups";
    public static final String TOTAL_OBJECTS = "TotalObjects";
    public static final String OBJECT_SIZE = "ObjectSize";
    public static final String INGESTED = "ingested";
    public static final String DELETED = "deleted";
    public static final String REMAINED = "remained";
    public static final String CREATION_DATE = "CreationDate";

    public AccessionRegisterSummary() {
    }

    public AccessionRegisterSummary(Document document) {
        super(document);
    }

    public AccessionRegisterSummary(JsonNode content) {
        super(content);
    }

    public AccessionRegisterSummary(String content) {
        super(content);
    }

    public VitamDocument<AccessionRegisterSummary> newInstance(JsonNode content) {
        return new AccessionRegisterSummary(content);
    }

    public AccessionRegisterSummary setId(String id) {
        this.append("_id", id);
        return this;
    }

    public AccessionRegisterSummary setOriginatingAgency(String orgAgency) {
        this.append(ORIGINATING_AGENCY, orgAgency);
        return this;
    }

    public AccessionRegisterSummary setTotalUnits(RegisterValueDetailModel totalUnits) {
        this.append(TOTAL_UNITS, totalUnits);
        return this;
    }

    public RegisterValueDetailModel getTotalUnits() {
        try {
            return (RegisterValueDetailModel)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)this.get(TOTAL_UNITS)), RegisterValueDetailModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public AccessionRegisterSummary setTotalObjectGroups(RegisterValueDetailModel totalObjectGroups) {
        this.append(TOTAL_OBJECTGROUPS, totalObjectGroups);
        return this;
    }

    public RegisterValueDetailModel getTotalObjectGroups() {
        try {
            return (RegisterValueDetailModel)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)this.get(TOTAL_OBJECTGROUPS)), RegisterValueDetailModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public AccessionRegisterSummary setTotalObjects(RegisterValueDetailModel total) {
        this.append(TOTAL_OBJECTS, total);
        return this;
    }

    public RegisterValueDetailModel getTotalObjects() {
        try {
            return (RegisterValueDetailModel)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)this.get(TOTAL_OBJECTS)), RegisterValueDetailModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public AccessionRegisterSummary setObjectSize(RegisterValueDetailModel objectSize) {
        this.append(OBJECT_SIZE, objectSize);
        return this;
    }

    public RegisterValueDetailModel getTotalObjectSize() {
        try {
            return (RegisterValueDetailModel)JsonHandler.getFromJsonNode((JsonNode)JsonHandler.toJsonNode((Object)this.get(OBJECT_SIZE)), RegisterValueDetailModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public AccessionRegisterSummary setCreationDate(String creationDate) {
        this.append(CREATION_DATE, creationDate);
        return this;
    }

    public String getOriginatingAgency() {
        return this.getString(ORIGINATING_AGENCY);
    }
}

