/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.xsrf.filter;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;

public class XSRFFilter
implements Filter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(XSRFFilter.class);
    private static final String CSRF_STATE_TOKEN_DOES_NOT_MATCH_ONE_PROVIDED = "CSRF state token does not match one provided";
    private static Map<String, String> tokenMap = new HashMap<String, String>();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String requestURI = req.getRequestURI();
        if (this.isUriNotProtected(requestURI)) {
            chain.doFilter(request, response);
            return;
        }
        String xhrToken = req.getHeader("X-CSRF-TOKEN");
        String sessionId = req.getRequestedSessionId();
        String token = tokenMap.get(sessionId);
        if (sessionId != null && token != null && token.equals(xhrToken)) {
            this.deleteTokenWhenLogout(req, sessionId);
            chain.doFilter(request, response);
        } else {
            this.deleteTokenWhenLogout(req, sessionId);
            LOGGER.error(CSRF_STATE_TOKEN_DOES_NOT_MATCH_ONE_PROVIDED);
            HttpServletResponse newResponse = (HttpServletResponse)response;
            newResponse.sendError(Response.Status.FORBIDDEN.getStatusCode(), CSRF_STATE_TOKEN_DOES_NOT_MATCH_ONE_PROVIDED);
            StreamUtils.closeSilently((InputStream)request.getInputStream());
        }
    }

    public void destroy() {
    }

    public static void addToken(String sessionId, String token) {
        tokenMap.put(sessionId, token);
    }

    private void deleteTokenWhenLogout(HttpServletRequest req, String sessionId) {
        if (req.getRequestURI().contains("/logout")) {
            tokenMap.remove(sessionId);
        }
    }

    private boolean isUriNotProtected(String requestURI) {
        return requestURI.contains("/login") || requestURI.contains("/logout") || requestURI.contains("/tenants") || requestURI.contains("/messages/logbook") || requestURI.contains("/archiveunit/objects/download") || requestURI.contains("/archiveunit/dipexport") || requestURI.contains("/securemode") || requestURI.contains("/admintenant") || requestURI.contains("permissions");
    }
}

