/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.json.JsonHandler;

public class ClassificationLevelUtil {
    private static final String PATH_CLASSIFICATION_LEVEL = "ArchiveUnit._mgt.ClassificationRule.ClassificationLevel";

    private ClassificationLevelUtil() {
    }

    public static boolean checkClassificationLevel(JsonNode archiveUnit) {
        String classificationLevelValue = null;
        JsonNode classificationLevel = JsonHandler.findNode((JsonNode)archiveUnit, (String)PATH_CLASSIFICATION_LEVEL);
        if (!classificationLevel.isMissingNode()) {
            classificationLevelValue = classificationLevel.asText();
        }
        return ClassificationLevelUtil.checkClassificationLevel(classificationLevelValue);
    }

    public static boolean checkClassificationLevel(String classificationLevelValue) {
        if (classificationLevelValue != null) {
            return VitamConfiguration.getClassificationLevel().getAllowList().contains(classificationLevelValue);
        }
        return VitamConfiguration.getClassificationLevel().authorizeNotDefined();
    }
}

