/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.thread;

import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedVitamThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadIndex = new AtomicInteger(0);
    private final String baseName;

    public NamedVitamThreadFactory(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        VitamSession initialVitamSession = VitamThreadUtils.getVitamSession();
        VitamThreadFactory.VitamThread thread = (VitamThreadFactory.VitamThread)VitamThreadFactory.getInstance().newThread(() -> {
            VitamThreadUtils.getVitamSession().mutateFrom(initialVitamSession);
            runnable.run();
        });
        thread.setName(this.baseName + "-" + initialVitamSession.getTenantId() + "-" + this.threadIndex.getAndIncrement());
        return thread;
    }
}

