/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ExactSizeInputStream
extends FilterInputStream {
    private final long size;
    private long pos = 0L;
    private boolean isEOF = false;

    public ExactSizeInputStream(InputStream in, long size) throws IOException {
        super(in);
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid size " + size);
        }
        this.size = size;
        this.failFastIfEmptyStream();
    }

    private void failFastIfEmptyStream() throws IOException {
        if (this.size == 0L) {
            if (this.in.read() != -1) {
                throw new IOException("Broken stream. Expected EOF at position 0");
            }
            this.isEOF = true;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF) {
            return -1;
        }
        int result = this.in.read();
        int readBytes = result == -1 ? -1 : 1;
        this.checkEOF(readBytes);
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IllegalArgumentException();
        }
        if (this.isEOF) {
            return -1;
        }
        int maxLength = (int)Math.min(this.size - this.pos, (long)len);
        int result = this.in.read(b, off, maxLength);
        this.checkEOF(result);
        return result;
    }

    private void checkEOF(int readBytes) throws IOException {
        if (readBytes == -1) {
            throw new IOException("Broken stream. Premature EOF at position " + this.pos + ". Expected size = " + this.size);
        }
        this.pos += (long)readBytes;
        if (this.pos == this.size) {
            if (this.in.read() != -1) {
                throw new IOException("Broken stream. Expected EOF at position " + this.pos);
            }
            this.isEOF = true;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long toSkip = Math.min(n, this.size - this.pos);
        long skippedBytes = this.in.skip(toSkip);
        this.pos += skippedBytes;
        return skippedBytes;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public long getSize() {
        return this.size;
    }
}

