/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AdminStatusMessage;
import fr.gouv.vitam.common.server.application.resources.BasicVitamStatusServiceImpl;
import fr.gouv.vitam.common.server.application.resources.VersionHelper;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.server.application.resources.VitamStatusService;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/admin/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AdminStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminStatusResource.class);
    public static final String STATUS_URL = "/status";
    public static final String AUTOTEST_URL = "/autotest";
    public static final String VERSION_URL = "/version";
    public static final String METRIC_URL = "/metrics";
    private final VitamStatusService statusService;
    private final VitamServiceRegistry autotestService;

    public AdminStatusResource() {
        this(new BasicVitamStatusServiceImpl());
    }

    public AdminStatusResource(VitamStatusService statusService) {
        this(statusService, new VitamServiceRegistry().register(statusService));
    }

    public AdminStatusResource(VitamStatusService statusService, VitamServiceRegistry autotestService) {
        this.statusService = statusService;
        this.autotestService = autotestService;
    }

    public AdminStatusResource(VitamServiceRegistry autotestService) {
        this(new BasicVitamStatusServiceImpl(), autotestService);
    }

    @Path(value="/status")
    @GET
    @Produces(value={"application/json"})
    public Response adminStatus() {
        try {
            AdminStatusMessage message = new AdminStatusMessage(JsonHandler.toJsonNode((Object)ServerIdentity.getInstance()), this.statusService.getResourcesStatus(), this.statusService.getAdminStatus(), JsonHandler.toJsonNode(VersionHelper.getVersionSummary()));
            if (message.getStatus()) {
                return Response.ok((Object)message, (String)"application/json").build();
            }
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)message).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    @Path(value="/version")
    @GET
    @Produces(value={"application/json"})
    public Response adminVersion() {
        try {
            return Response.ok((Object)JsonHandler.toJsonNode(VersionHelper.getVersionDetailedInfo()), (String)"application/json").build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    @Path(value="/autotest")
    @GET
    @Produces(value={"application/json"})
    public Response adminAutotest() {
        ObjectNode status = this.autotestService.getAutotestStatus();
        return Response.status((int)status.get("httpCode").asInt()).entity((Object)status).build();
    }

    @Path(value="/metrics")
    @GET
    @Produces(value={"text/plain; version=0.0.4; charset=utf-8"})
    public Response prometheusMetrics() {
        return Response.ok().type("text/plain; version=0.0.4; charset=utf-8").entity(output -> {
            try (OutputStreamWriter writer = new OutputStreamWriter(output);){
                TextFormat.write004((Writer)writer, (Enumeration)CollectorRegistry.defaultRegistry.metricFamilySamples());
            }
        }).build();
    }
}

