/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application;

public enum VitamHttpHeader {
    STRATEGY_ID("X-Strategy-Id", ".+"),
    OFFER("X-Offer", ".+"),
    OFFERS_IDS("X-Offer-Ids", ".+"),
    OFFER_NO_CACHE("X-Offer-No-Cache", "true|false"),
    TENANT_ID("X-Tenant-Id", ".+"),
    APPLICATION_ID("X-Application-Id", ".+"),
    METHOD_OVERRIDE("X-Http-Method-Override", "get|put|delete"),
    QUALIFIER("X-Qualifier", ".+"),
    VERSION("X-Version", "[0-9]+"),
    X_CHUNK_LENGTH("X-Chunk-Length", "[0-9]+"),
    X_CONTENT_LENGTH("X-Content-Length", "[0-9]+"),
    X_DIGEST("X-digest", ".+"),
    X_DIGEST_ALGORITHM("X-digest-algorithm", ".+"),
    CONTEXT_ID("X-Context-Id", ".+"),
    X_CONTENT_SOURCE("X-CONTENT-SOURCE", ".+"),
    X_DATA_CATEGORY("X-Data-Category", ".+"),
    X_CONTENT_DESTINATION("X-CONTENT-DESTINATION", ".+"),
    X_CURSOR("X-Cursor", "true|false"),
    X_CURSOR_ID("X-Cursor-Id", ".+"),
    X_ADMIN_CROSS_TENANT_ACCESS_REQUEST_ALLOWED("X-Admin-Cross-Tenant-Access-Request-Allowed", "true|false");

    private String name;
    private String regExp;

    private VitamHttpHeader(String name, String regExp) {
        this.name = name;
        this.regExp = regExp;
    }

    public String getName() {
        return this.name;
    }

    public String getRegExp() {
        return this.regExp;
    }

    public static VitamHttpHeader get(String headerName) {
        for (VitamHttpHeader v : VitamHttpHeader.values()) {
            if (!v.getName().equals(headerName)) continue;
            return v;
        }
        return null;
    }
}

