/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.security.waf;

import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.SanityChecker;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Priority(value=1001)
public class SanityCheckerCommonFilter
implements ContainerRequestFilter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SanityCheckerCommonFilter.class);
    private static final String CHECK_SANITY = "CHECK_SANITY";
    private static final String CODE_VITAM = "code_vitam";

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            SanityChecker.checkHeadersMap((MultivaluedMap<String, String>)requestContext.getHeaders());
            SanityChecker.checkUriParametersMap((MultivaluedMap<String, String>)requestContext.getUriInfo().getPathParameters());
            SanityChecker.checkUriParametersMap((MultivaluedMap<String, String>)requestContext.getUriInfo().getQueryParameters());
        }
        catch (InvalidParseOperationException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            requestContext.abortWith(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorEntity(Response.Status.PRECONDITION_FAILED, exc.getMessage())).build());
        }
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CHECK_SANITY).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }
}

