/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.security;

import com.google.common.base.Joiner;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.security.IllegalPathException;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.SafeFile;
import org.owasp.esapi.errors.ValidationException;

public class SafeFileChecker {
    public static final Pattern FILENAME_PATTERN = Pattern.compile("^[a-zA-Z0-9\\-_@]+(\\.[a-zA-Z0-9\\-_@]+)*$");
    private static final Pattern PATH_COMPONENT_PATTERN = Pattern.compile("^[a-zA-Z0-9\\-_@]+(\\.[a-zA-Z0-9\\-_@]+)*$");
    private static final AlertService alertService = new AlertServiceImpl();
    public static final String LOCAL_ENVIRONMENT = "local";

    private SafeFileChecker() {
    }

    public static File checkSafeFilePath(String safeRootPath, String ... subPaths) throws IllegalPathException {
        return SafeFileChecker.checkSafePath(safeRootPath, subPaths, false);
    }

    public static File checkSafeDirPath(String safeRootPath, String ... subPaths) throws IllegalPathException {
        return SafeFileChecker.checkSafePath(safeRootPath, subPaths, true);
    }

    public static void checkSafeRessourceFilePath(String resourceName) throws IllegalPathException {
        SafeFileChecker.checkSafePath(VitamConfiguration.getVitamConfigFolder(), new String[]{resourceName}, false);
    }

    private static File checkSafePath(String safeRootPath, String[] subPaths, boolean isDirectory) throws IllegalPathException {
        if (StringUtils.isEmpty((CharSequence)safeRootPath)) {
            throw new IllegalPathException("Null or empty root path");
        }
        if (subPaths == null) {
            throw new IllegalPathException("Null sub paths");
        }
        for (String subPath : subPaths) {
            if (subPath != null) continue;
            throw new IllegalPathException("Null sub path");
        }
        Object finalPath = safeRootPath;
        if (!((String)finalPath).endsWith(File.separator)) {
            finalPath = (String)finalPath + File.separator;
        }
        finalPath = (String)finalPath + Joiner.on((String)File.separator).join((Object[])subPaths);
        try {
            if (!isDirectory) {
                if (ArrayUtils.isEmpty((Object[])subPaths)) {
                    throw new VitamRuntimeException("Missing filename");
                }
                String fileName = subPaths[subPaths.length - 1];
                if (!FILENAME_PATTERN.matcher(fileName).matches()) {
                    throw new VitamRuntimeException("Invalid filename: '" + fileName + "'");
                }
            }
            int nbDirectorySubPaths = isDirectory ? subPaths.length : subPaths.length - 1;
            for (int i = 0; i < nbDirectorySubPaths; ++i) {
                String subPath;
                subPath = subPaths[i];
                if (PATH_COMPONENT_PATTERN.matcher(subPath).matches()) continue;
                throw new VitamRuntimeException("Invalid sub-path: '" + subPath + "'");
            }
            File sanityCheckedFile = SafeFileChecker.doSanityCheck((String)finalPath);
            if (VitamConfiguration.getEnvironmentName() != null && VitamConfiguration.getEnvironmentName().equals(LOCAL_ENVIRONMENT)) {
                return sanityCheckedFile;
            }
            SafeFileChecker.doCanonicalPathCheck(sanityCheckedFile);
            return sanityCheckedFile;
        }
        catch (Exception e) {
            String error = "Check path traversal error: '" + (String)finalPath + "'";
            alertService.createAlert(error);
            throw new IllegalPathException(error, e);
        }
    }

    private static File doSanityCheck(String path) throws ValidationException {
        return new SafeFile(path);
    }

    private static void doCanonicalPathCheck(File file) throws IOException {
        String canonicalPath;
        String path = file.getPath();
        if (!path.equals(canonicalPath = file.getCanonicalPath())) {
            throw new IOException(String.format("Invalid path (%s) did not match canonical : %s", path, canonicalPath));
        }
    }
}

