/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.unit;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.unit.InheritanceModel;
import fr.gouv.vitam.common.model.unit.RuleModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RuleCategoryModel {
    private static final String CLASSIFICATION_AUDIENCE = "ClassificationAudience";
    private static final String CLASSIFICATION_LEVEL = "ClassificationLevel";
    private static final String CLASSIFICATION_OWNER = "ClassificationOwner";
    public static final String FINAL_ACTION = "FinalAction";
    private static final String CLASSIFICATION_REASSESSING_DATE = "ClassificationReassessingDate";
    private static final String NEED_REASSESSING_AUTHORIZATION = "NeedReassessingAuthorization";
    @JsonProperty(value="Rules")
    private List<RuleModel> rules = new ArrayList<RuleModel>();
    @JsonProperty(value="ClassificationAudience")
    private String classificationAudience;
    @JsonProperty(value="ClassificationLevel")
    private String classificationLevel;
    @JsonProperty(value="ClassificationOwner")
    private String classificationOwner;
    @JsonProperty(value="ClassificationReassessingDate")
    private String classificationReassessingDate;
    @JsonProperty(value="NeedReassessingAuthorization")
    private Boolean needReassessingAuthorization;
    @JsonProperty(value="Inheritance")
    private InheritanceModel inheritance;
    @JsonProperty(value="FinalAction")
    private String finalAction;

    public List<RuleModel> getRules() {
        return this.rules;
    }

    public void setRules(List<RuleModel> listRUle) {
        this.rules = listRUle;
    }

    public InheritanceModel getInheritance() {
        return this.inheritance;
    }

    public String getFinalAction() {
        return this.finalAction;
    }

    public void setFinalAction(String finalAction) {
        this.finalAction = finalAction;
    }

    @JsonIgnore
    public void merge(RuleCategoryModel ruleCategoryModel) {
        if (ruleCategoryModel == null) {
            return;
        }
        this.rules.addAll(ruleCategoryModel.getRules());
        if (this.inheritance != null) {
            this.inheritance.merge(ruleCategoryModel.getInheritance());
        } else {
            this.inheritance = ruleCategoryModel.getInheritance();
        }
        this.finalAction = ruleCategoryModel.getFinalAction();
    }

    @JsonIgnore
    public boolean isPreventInheritance() {
        return this.inheritance != null && this.inheritance.isPreventInheritance() != null && Boolean.TRUE.equals(this.inheritance.isPreventInheritance());
    }

    @JsonIgnore
    public void setPreventInheritance(Boolean preventInheritance) {
        if (this.inheritance == null) {
            this.inheritance = new InheritanceModel();
        }
        this.inheritance.setPreventInheritance(preventInheritance);
    }

    @JsonIgnore
    public void addAllPreventRulesId(List<String> preventRulesId) {
        if (this.inheritance == null) {
            this.inheritance = new InheritanceModel();
        }
        this.inheritance.getPreventRulesId().addAll(preventRulesId);
    }

    @JsonIgnore
    public void addToPreventRulesId(String preventRulesId) {
        if (this.inheritance == null) {
            this.inheritance = new InheritanceModel();
        }
        this.inheritance.getPreventRulesId().add(preventRulesId);
    }

    public String getClassificationLevel() {
        return this.classificationLevel;
    }

    public void setClassificationLevel(String classificationLevel) {
        this.classificationLevel = classificationLevel;
    }

    public String getClassificationOwner() {
        return this.classificationOwner;
    }

    public void setClassificationOwner(String classificationOwner) {
        this.classificationOwner = classificationOwner;
    }

    public String getClassificationAudience() {
        return this.classificationAudience;
    }

    public void setClassificationAudience(String classificationAudience) {
        this.classificationAudience = classificationAudience;
    }

    public String getClassificationReassessingDate() {
        return this.classificationReassessingDate;
    }

    public void setClassificationReassessingDate(String classificationReassessingDate) {
        this.classificationReassessingDate = classificationReassessingDate;
    }

    public Boolean isNeedReassessingAuthorization() {
        return this.needReassessingAuthorization;
    }

    public void setNeedReassessingAuthorization(Boolean needReassessingAuthorization) {
        this.needReassessingAuthorization = needReassessingAuthorization;
    }

    @JsonIgnore
    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(CLASSIFICATION_AUDIENCE, this.classificationAudience);
        properties.put(CLASSIFICATION_LEVEL, this.classificationLevel);
        properties.put(CLASSIFICATION_OWNER, this.classificationOwner);
        properties.put(CLASSIFICATION_REASSESSING_DATE, this.classificationReassessingDate);
        properties.put(NEED_REASSESSING_AUTHORIZATION, this.needReassessingAuthorization);
        properties.put(FINAL_ACTION, this.finalAction);
        properties.values().removeIf(Objects::isNull);
        return properties;
    }
}

