/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.metrics;

import fr.gouv.vitam.common.metrics.DynamicGauge;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public final class GaugeUtils {
    private GaugeUtils() {
    }

    public static Collector createCustomGauge(String name, String help, Supplier<Double> supplier) {
        return GaugeUtils.createCustomGauge(name, help, Collections.emptyMap(), supplier);
    }

    public static Collector createCustomGauge(String name, String help, Map<String, String> labels, Supplier<Double> supplier) {
        ArrayList<String> labelNames = new ArrayList<String>(labels.keySet());
        ArrayList<String> labelValues = new ArrayList<String>(labels.values());
        return new DynamicGauge(name, help, labelNames, () -> Map.of(labelValues, (Double)supplier.get()));
    }

    public static Collector createCustomGauge(String name, String help, List<String> labelNames, Supplier<Map<List<String>, Double>> metricsSupplier) {
        return new DynamicGauge(name, help, labelNames, metricsSupplier);
    }
}

