/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.mapping.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import fr.gouv.vitam.common.mapping.serializer.XMLGregorianCalendarSerializer;
import javax.xml.datatype.XMLGregorianCalendar;

public class VitamObjectMapper {
    private static final ObjectMapper deserializationObjectMapper = new ObjectMapper();
    private static final ObjectMapper serializationObjectMapper = new ObjectMapper();

    private VitamObjectMapper() {
    }

    public static ObjectMapper getDeserializationObjectMapper() {
        return deserializationObjectMapper;
    }

    public static ObjectMapper getSerializationObjectMapper() {
        return serializationObjectMapper;
    }

    static {
        deserializationObjectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
        deserializationObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        deserializationObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        deserializationObjectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        deserializationObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        serializationObjectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
        serializationObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        serializationObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        serializationObjectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        SimpleModule module = new SimpleModule();
        module.addSerializer(XMLGregorianCalendar.class, (JsonSerializer)new XMLGregorianCalendarSerializer());
        serializationObjectMapper.registerModule((Module)module);
        JavaTimeModule module1 = new JavaTimeModule();
        serializationObjectMapper.registerModule((Module)module1);
    }
}

