/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.mapping.dip;

import fr.gouv.culture.archivesdefrance.seda.v2.BinaryDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectGroupType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectPackageType;
import fr.gouv.culture.archivesdefrance.seda.v2.DescriptiveTechnicalMetadataType;
import fr.gouv.culture.archivesdefrance.seda.v2.FileInfoType;
import fr.gouv.culture.archivesdefrance.seda.v2.FormatIdentificationType;
import fr.gouv.culture.archivesdefrance.seda.v2.IdentifierType;
import fr.gouv.culture.archivesdefrance.seda.v2.MessageDigestBinaryObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.MinimalDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.PhysicalDataObjectType;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.mapping.dip.CoreMetadataMapper;
import fr.gouv.vitam.common.mapping.dip.PhysicalDimensionsMapper;
import fr.gouv.vitam.common.mapping.dip.TransformJsonTreeToListOfXmlElement;
import fr.gouv.vitam.common.model.objectgroup.FileInfoModel;
import fr.gouv.vitam.common.model.objectgroup.FormatIdentificationModel;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.PersistentIdentifierModel;
import fr.gouv.vitam.common.model.objectgroup.QualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.lang3.StringUtils;

public class ObjectGroupMapper {
    private static final PhysicalDimensionsMapper physicalDimensionsMapper = new PhysicalDimensionsMapper();
    private final CoreMetadataMapper coreMetadataMapper = new CoreMetadataMapper();

    public DataObjectPackageType map(ObjectGroupResponse objectGroupResponse) throws InternalServerException {
        DataObjectPackageType dataObjectPackageType = new DataObjectPackageType();
        if (!objectGroupResponse.getQualifiers().isEmpty()) {
            String objectGroupId = objectGroupResponse.getId();
            DataObjectGroupType dataObjectGroup = new DataObjectGroupType();
            dataObjectGroup.setId(objectGroupId);
            for (QualifiersModel qualifiersModel : objectGroupResponse.getQualifiers()) {
                List versions = qualifiersModel.getVersions();
                for (VersionsModel version : versions) {
                    MinimalDataObjectType minimalDataObjectType = version != null && version.getPhysicalId() != null && !version.getPhysicalId().isEmpty() ? this.mapPhysicalDataObject(version) : this.mapBinaryDataObject(version);
                    minimalDataObjectType.setDataObjectUse(version.getDataObjectUse());
                    minimalDataObjectType.setDataObjectNumber(version.getDataObjectNumber());
                    if (version.getPersistentIdentifier() != null) {
                        minimalDataObjectType.getPersistentIdentifier().addAll(version.getPersistentIdentifier().stream().map(this::mapPersistentIdentifiers).collect(Collectors.toList()));
                    }
                    dataObjectGroup.getBinaryDataObjectOrPhysicalDataObject().add(minimalDataObjectType);
                }
            }
            dataObjectPackageType.getDataObjectGroupOrBinaryDataObjectOrPhysicalDataObject().add(dataObjectGroup);
        }
        return dataObjectPackageType;
    }

    private BinaryDataObjectType mapBinaryDataObject(VersionsModel version) throws InternalServerException {
        FileInfoModel fileInfoModel;
        BinaryDataObjectType binaryDataObjectType = new BinaryDataObjectType();
        if (version != null) {
            FormatIdentificationType formatIdentificationType = new FormatIdentificationType();
            FormatIdentificationModel formatIdentification = version.getFormatIdentification();
            if (formatIdentification != null) {
                formatIdentificationType.setFormatLitteral(formatIdentification.getFormatLitteral());
                formatIdentificationType.setMimeType(formatIdentification.getMimeType());
                formatIdentificationType.setFormatId(formatIdentification.getFormatId());
                formatIdentificationType.setEncoding(formatIdentification.getEncoding());
                binaryDataObjectType.setFormatIdentification(formatIdentificationType);
            }
        }
        FileInfoModel fileInfoModel2 = fileInfoModel = version != null ? version.getFileInfoModel() : null;
        if (fileInfoModel != null) {
            FileInfoType fileInfoType = new FileInfoType();
            fileInfoType.setFilename(StringUtils.defaultString((String)fileInfoModel.getFilename()));
            fileInfoType.setCreatingApplicationName(fileInfoModel.getCreatingApplicationName());
            fileInfoType.setCreatingApplicationVersion(fileInfoModel.getCreatingApplicationVersion());
            fileInfoType.setCreatingOs(fileInfoModel.getCreatingOs());
            fileInfoType.setCreatingOsVersion(fileInfoModel.getCreatingOsVersion());
            String dateCreatedByApplication = fileInfoModel.getDateCreatedByApplication();
            String lastModified = fileInfoModel.getLastModified();
            try {
                if (dateCreatedByApplication != null && !dateCreatedByApplication.isEmpty()) {
                    fileInfoType.setDateCreatedByApplication(DatatypeFactory.newInstance().newXMLGregorianCalendar(dateCreatedByApplication));
                }
                if (lastModified != null && !lastModified.isEmpty()) {
                    fileInfoType.setLastModified(DatatypeFactory.newInstance().newXMLGregorianCalendar(lastModified));
                }
            }
            catch (DatatypeConfigurationException e) {
                throw new InternalServerException(String.format("Exception occurred During parsing of field DateCreatedByApplication or lastModified: %s", dateCreatedByApplication));
            }
            binaryDataObjectType.setFileInfo(fileInfoType);
        }
        if (version != null) {
            binaryDataObjectType.setUri(version.getUri());
            binaryDataObjectType.setSize(BigInteger.valueOf(version.getSize()));
            MessageDigestBinaryObjectType messageDigestBinaryObjectType = new MessageDigestBinaryObjectType();
            messageDigestBinaryObjectType.setAlgorithm(StringUtils.trimToEmpty((String)version.getAlgorithm()));
            messageDigestBinaryObjectType.setValue(StringUtils.trimToEmpty((String)version.getMessageDigest()));
            binaryDataObjectType.setMessageDigest(messageDigestBinaryObjectType);
            this.mapCommonInformations(version, binaryDataObjectType);
            binaryDataObjectType.setMetadata(this.coreMetadataMapper.map(version.getMetadata()));
            DescriptiveTechnicalMetadataType otherMetadata = new DescriptiveTechnicalMetadataType();
            Map otherMetadataMap = version.getOtherMetadata();
            if (otherMetadataMap != null && !otherMetadataMap.isEmpty()) {
                otherMetadata.getAny().addAll(TransformJsonTreeToListOfXmlElement.mapJsonToElement(otherMetadataMap));
                binaryDataObjectType.setOtherMetadata(otherMetadata);
            }
        }
        return binaryDataObjectType;
    }

    private PhysicalDataObjectType mapPhysicalDataObject(VersionsModel version) {
        PhysicalDataObjectType physicalDataObjectType = new PhysicalDataObjectType();
        physicalDataObjectType.setPhysicalDimensions(physicalDimensionsMapper.map(version.getPhysicalDimensionsModel()));
        this.mapCommonInformations(version, physicalDataObjectType);
        IdentifierType identifierType = new IdentifierType();
        identifierType.setValue(version.getPhysicalId());
        physicalDataObjectType.setPhysicalId(identifierType);
        physicalDataObjectType.getAny().addAll(TransformJsonTreeToListOfXmlElement.mapJsonToElement(version.getAny()));
        return physicalDataObjectType;
    }

    private <T extends MinimalDataObjectType> void mapCommonInformations(VersionsModel version, T minimalDataObjectType) {
        minimalDataObjectType.setDataObjectVersion(version.getDataObjectVersion());
        minimalDataObjectType.setId(version.getId());
        if (version.getDataObjectProfile() != null && !version.getDataObjectProfile().isEmpty()) {
            IdentifierType identifierType = new IdentifierType();
            identifierType.setValue(version.getDataObjectProfile());
            minimalDataObjectType.setDataObjectProfile(identifierType);
        }
    }

    private fr.gouv.vitam.common.model.unit.PersistentIdentifierModel mapPersistentIdentifiers(PersistentIdentifierModel identifierModel) {
        if (identifierModel == null) {
            return null;
        }
        fr.gouv.vitam.common.model.unit.PersistentIdentifierModel persistentIdentifierModelUnit = new fr.gouv.vitam.common.model.unit.PersistentIdentifierModel();
        persistentIdentifierModelUnit.setPersistentIdentifierOrigin(identifierModel.getPersistentIdentifierOrigin());
        persistentIdentifierModelUnit.setPersistentIdentifierReference(identifierModel.getPersistentIdentifierReference());
        persistentIdentifierModelUnit.setPersistentIdentifierContent(identifierModel.getPersistentIdentifierContent());
        persistentIdentifierModelUnit.setPersistentIdentifierType(identifierModel.getPersistentIdentifierType());
        return persistentIdentifierModelUnit;
    }
}

