/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.mapping.dip;

import fr.gouv.culture.archivesdefrance.seda.v2.AccessRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.AppraisalRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.ClassificationRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.DisseminationRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.ManagementType;
import fr.gouv.culture.archivesdefrance.seda.v2.ReuseRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.StorageRuleType;
import fr.gouv.vitam.common.mapping.dip.RuleMapper;
import fr.gouv.vitam.common.model.unit.ManagementModel;
import javax.xml.datatype.DatatypeConfigurationException;

public class ManagementMapper {
    private RuleMapper ruleMapper;

    public ManagementMapper(RuleMapper ruleMapper) {
        this.ruleMapper = ruleMapper;
    }

    public ManagementType map(ManagementModel managementModel) throws DatatypeConfigurationException {
        ManagementType managementType = new ManagementType();
        managementType.setNeedAuthorization(managementModel.isNeedAuthorization());
        managementType.setAccessRule(this.ruleMapper.fillCommonRule(managementModel.getAccess(), AccessRuleType::new));
        managementType.setAppraisalRule(this.ruleMapper.fillCommonRule(managementModel.getAppraisal(), AppraisalRuleType::new));
        managementType.setClassificationRule(this.ruleMapper.fillCommonRule(managementModel.getClassification(), ClassificationRuleType::new));
        managementType.setDisseminationRule(this.ruleMapper.fillCommonRule(managementModel.getDissemination(), DisseminationRuleType::new));
        managementType.setReuseRule(this.ruleMapper.fillCommonRule(managementModel.getReuse(), ReuseRuleType::new));
        managementType.setStorageRule(this.ruleMapper.fillCommonRule(managementModel.getStorage(), StorageRuleType::new));
        managementType.setHoldRule(this.ruleMapper.fillHoldRule(managementModel.getHold()));
        managementType.setUpdateOperation(managementModel.getUpdateOperationType());
        return managementType;
    }
}

