/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.InvalidJsonSchemaException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.json.JsonSchemaValidationException;
import fr.gouv.vitam.common.json.VitamDateTimeAttribute;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JsonSchemaValidator {
    private static final JsonSchemaFactory JSON_SCHEMA_FACTORY = JsonSchemaValidator.getJsonSchemaFactory();
    private final JsonSchema jsonSchema;
    private static final String DATE_TIME_VITAM = "date-time-vitam";

    public static JsonSchemaValidator forBuiltInSchema(String schemaFilename) {
        JsonSchemaValidator jsonSchemaValidator;
        block8: {
            InputStream is = JsonSchemaValidator.class.getResourceAsStream(schemaFilename);
            try {
                JsonNode schemaJson = JsonHandler.getFromInputStream((InputStream)is);
                JsonSchema jsonSchema = JSON_SCHEMA_FACTORY.getJsonSchema(schemaJson);
                jsonSchemaValidator = new JsonSchemaValidator(jsonSchema);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessingException | InvalidParseOperationException | IOException e) {
                    throw new VitamRuntimeException("Could not initialize built-in schema file " + schemaFilename);
                }
            }
            is.close();
        }
        return jsonSchemaValidator;
    }

    public static JsonSchemaValidator forUserSchema(String schemaJsonAsString) throws InvalidJsonSchemaException {
        try {
            JsonNode schemaAsJson = JsonHandler.getFromString((String)schemaJsonAsString);
            ProcessingReport pr = JSON_SCHEMA_FACTORY.getSyntaxValidator().validateSchema(schemaAsJson);
            if (!pr.isSuccess()) {
                throw new InvalidJsonSchemaException("External Schema is not valid");
            }
            JsonSchema jsonSchema = JSON_SCHEMA_FACTORY.getJsonSchema(schemaAsJson);
            return new JsonSchemaValidator(jsonSchema);
        }
        catch (ProcessingException | InvalidParseOperationException e) {
            throw new InvalidJsonSchemaException("External Schema is not valid", e);
        }
    }

    private JsonSchemaValidator(JsonSchema jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    private static JsonSchemaFactory getJsonSchemaFactory() {
        Library library = DraftV4Library.get().thaw().addFormatAttribute(DATE_TIME_VITAM, VitamDateTimeAttribute.getInstance()).freeze();
        MessageBundle bundle = MessageBundles.getBundle(JsonSchemaValidationBundle.class);
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary("http://vitam-json-schema.org/draft-04/schema#", library).setValidationMessages(bundle).freeze();
        return JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
    }

    public void validateJson(JsonNode jsonNode) throws JsonSchemaValidationException {
        try {
            ProcessingReport report = this.jsonSchema.validate(jsonNode);
            if (!report.isSuccess()) {
                JsonNode error = ((ListProcessingReport)report).asJson();
                ObjectNode errorNode = JsonHandler.createObjectNode();
                errorNode.set("validateJson", error);
                throw new JsonSchemaValidationException("Document schema validation failed : \n" + String.valueOf(errorNode));
            }
        }
        catch (ProcessingException e) {
            throw new JsonSchemaValidationException("Document schema validation failed", e);
        }
    }
}

