/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.BaseXx;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public final class CanonicalJsonFormatter {
    private static final char[] hexChars = "0123456789abcdef".toCharArray();
    private final AsciiWriter writer;

    public static InputStream serialize(JsonNode node) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);
            CanonicalJsonFormatter.serialize(node, (OutputStream)outputStream);
            return outputStream.toInputStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO exception on memory stream", e);
        }
    }

    public static byte[] serializeToByteArray(JsonNode node) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);
            CanonicalJsonFormatter.serialize(node, (OutputStream)outputStream);
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO exception on memory stream", e);
        }
    }

    public static void serialize(JsonNode node, OutputStream outputStream) throws IOException {
        try (AsciiWriter writer = new AsciiWriter(outputStream);){
            new CanonicalJsonFormatter(writer).format(node);
            writer.flush();
        }
    }

    private CanonicalJsonFormatter(AsciiWriter writer) {
        this.writer = writer;
    }

    private void format(JsonNode node) throws IOException {
        if (node.isObject()) {
            this.formatObject((ObjectNode)node);
        } else if (node.isArray()) {
            this.formatArray((ArrayNode)node);
        } else if (node.isTextual()) {
            this.formatString(node.textValue());
        } else if (node.isNull()) {
            this.formatNull();
        } else if (node.isBoolean()) {
            this.formatBoolean(node.booleanValue());
        } else if (node.isInt()) {
            this.formatInt(node.intValue());
        } else if (node.isLong()) {
            this.formatLong(node.longValue());
        } else if (node.isFloat()) {
            this.formatFloat(node.floatValue());
        } else if (node.isDouble()) {
            this.formatDouble(node.doubleValue());
        } else if (node.isBinary()) {
            this.formatBinary(node.binaryValue());
        } else {
            throw new UnsupportedOperationException("Unsupported json node type " + String.valueOf(node.getNodeType()) + " '" + node.toString() + "'");
        }
    }

    private void formatDouble(double val) throws IOException {
        this.writer.append(Double.toString(val));
    }

    private void formatFloat(float val) throws IOException {
        this.writer.append(Float.toString(val));
    }

    private void formatLong(long val) throws IOException {
        this.writer.append(Long.toString(val));
    }

    private void formatInt(int val) throws IOException {
        this.writer.append(Integer.toString(val));
    }

    private void formatBoolean(boolean flag) throws IOException {
        this.writer.append(flag ? "true" : "false");
    }

    private void formatNull() throws IOException {
        this.writer.append("null");
    }

    private void formatObject(ObjectNode node) throws IOException {
        List sortedKeys = IteratorUtils.toList((Iterator)node.fieldNames());
        sortedKeys.sort(Comparator.naturalOrder());
        this.writer.append('{');
        for (int i = 0; i < sortedKeys.size(); ++i) {
            if (i > 0) {
                this.writer.append(',');
            }
            String key = (String)sortedKeys.get(i);
            this.formatString(key);
            this.writer.append(':');
            this.format(node.get(key));
        }
        this.writer.append('}');
    }

    private void formatArray(ArrayNode node) throws IOException {
        this.writer.append('[');
        Iterator iterator = node.iterator();
        if (iterator.hasNext()) {
            this.format((JsonNode)iterator.next());
            while (iterator.hasNext()) {
                this.writer.append(',');
                this.format((JsonNode)iterator.next());
            }
        }
        this.writer.append(']');
    }

    private void formatString(String string) throws IOException {
        this.writer.append('\"');
        int lastPos = 0;
        int curPos = 0;
        for (int curPor = 0; curPor < string.length(); ++curPor) {
            char c = string.charAt(curPos);
            if (c < ' ' || c > '\u007f' || c == '\"' || c == '\\') {
                this.writer.append(string, lastPos, curPos);
                lastPos = curPos + 1;
                switch (c) {
                    case '\"': {
                        this.writer.append("\\\"");
                        break;
                    }
                    case '\\': {
                        this.writer.append("\\\\");
                        break;
                    }
                    case '\b': {
                        this.writer.append("\\b");
                        break;
                    }
                    case '\f': {
                        this.writer.append("\\f");
                        break;
                    }
                    case '\n': {
                        this.writer.append("\\n");
                        break;
                    }
                    case '\r': {
                        this.writer.append("\\r");
                        break;
                    }
                    case '\t': {
                        this.writer.append("\\t");
                        break;
                    }
                    default: {
                        this.writer.append("\\u");
                        this.writer.append(hexChars[c >> 12 & 0xF]);
                        this.writer.append(hexChars[c >> 8 & 0xF]);
                        this.writer.append(hexChars[c >> 4 & 0xF]);
                        this.writer.append(hexChars[c & 0xF]);
                    }
                }
            }
            ++curPos;
        }
        this.writer.append(string, lastPos, curPos);
        this.writer.append('\"');
    }

    private void formatBinary(byte[] data) throws IOException {
        this.writer.append('\"');
        this.writer.append(BaseXx.getBase64((byte[])data));
        this.writer.append('\"');
    }

    private static final class AsciiWriter
    implements AutoCloseable {
        private final OutputStream outputStream;

        AsciiWriter(OutputStream os) {
            this.outputStream = os;
        }

        public void append(char c) throws IOException {
            this.outputStream.write(c);
        }

        public void append(String s) throws IOException {
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                this.outputStream.write(s.charAt(i));
            }
        }

        public void append(String s, int start, int end) throws IOException {
            for (int i = start; i < end; ++i) {
                this.outputStream.write(s.charAt(i));
            }
        }

        public void flush() throws IOException {
            this.outputStream.flush();
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }
    }
}

