/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.iterables;

import java.util.Iterator;

public class CountingIterator<T>
implements Iterator<EntryWithIndex<T>> {
    private final Iterator<T> innerIterator;
    private int entryIndex = 0;

    public CountingIterator(Iterator<T> innerIterator) {
        this.innerIterator = innerIterator;
    }

    @Override
    public boolean hasNext() {
        return this.innerIterator.hasNext();
    }

    @Override
    public EntryWithIndex<T> next() {
        return new EntryWithIndex<T>(this.innerIterator.next(), this.entryIndex++);
    }

    public static class EntryWithIndex<T> {
        private final T value;
        private final int index;

        public EntryWithIndex(T value, int index) {
            this.value = value;
            this.index = index;
        }

        public T getValue() {
            return this.value;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

