/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.date.converter.resolver;

import fr.gouv.vitam.common.date.converter.resolver.DateResolver;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OffsetOnlyResolver
implements DateResolver {
    @Override
    public boolean supports(String input) {
        return input.matches("^[+-]?\\d{4,}-\\d{2}-\\d{2}[+-]\\d{2}:\\d{2}$");
    }

    @Override
    public TemporalAccessor resolve(String input) {
        Pattern pattern = Pattern.compile("^([+-]?\\d{4,}-\\d{2}-\\d{2})([+-]\\d{2}:\\d{2})$");
        Matcher matcher = pattern.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid date format for OffsetOnlyResolver: " + input);
        }
        String datePart = matcher.group(1);
        String offsetPart = matcher.group(2);
        LocalDate date = LocalDate.parse(datePart);
        ZoneOffset offset = ZoneOffset.of(offsetPart);
        return OffsetDateTime.of(date, LocalTime.MIDNIGHT, offset);
    }
}

