/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.VitamRestEasyConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Invocation;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.TokenIterator;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicTokenIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.SelfExpandingBufferredInputStream;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.DelegatingOutputStream;

public class VitamApacheHttpClientEngine
implements ClientHttpEngine {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamApacheHttpClientEngine.class);
    private static final ConnectionKeepAliveStrategy MY_KEEP_ALIVE_STRATEGY;
    private static final VitamConnectionReuseStrategy MY_CONNECTION_REUSE_STRATEGY;
    private CookieStore cookieStore;
    private RequestConfig requestConfig;
    private HttpClientConnectionManager httpClientConnectionManager;
    private Map<VitamRestEasyConfiguration, Object> config;
    private final int connectTimeout;
    private final int socketTimeout;
    private final int bufferSize;
    private final boolean bufferingEnabled;
    private SSLContext sslContext;
    private int responseBufferSize = 0;
    private CloseableHttpClient httpClient;
    private boolean closed;

    public VitamApacheHttpClientEngine(Map<VitamRestEasyConfiguration, Object> config) {
        Object proxyUri;
        HttpClientBuilder clientBuilder;
        this.config = config;
        Object cm0 = VitamRestEasyConfiguration.CONNECTION_MANAGER.getObject(config);
        if (cm0 != null && !(cm0 instanceof HttpClientConnectionManager)) {
            LOGGER.error(VitamRestEasyConfiguration.CONNECTION_MANAGER.name() + " missing");
            throw new IllegalArgumentException(VitamRestEasyConfiguration.CONNECTION_MANAGER.name() + " will be ignored");
        }
        this.httpClientConnectionManager = (HttpClientConnectionManager)cm0;
        Object reqConfig = VitamRestEasyConfiguration.REQUEST_CONFIG.getObject(config);
        if (reqConfig != null && !(reqConfig instanceof RequestConfig)) {
            LOGGER.warn(VitamRestEasyConfiguration.REQUEST_CONFIG.name() + " will be ignored");
        }
        this.sslContext = (SSLContext)VitamRestEasyConfiguration.SSL_CONTEXT.getObject(config);
        if (VitamRestEasyConfiguration.CACHE_ENABLED.isTrue(config)) {
            CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(VitamConfiguration.getMaxCacheEntries()).setMaxObjectSize(8192L).setSharedCache(true).build();
            clientBuilder = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig);
            clientBuilder.useSystemProperties();
        } else {
            clientBuilder = HttpClientBuilder.create();
        }
        clientBuilder.useSystemProperties();
        boolean disableAutomaticRetries = VitamRestEasyConfiguration.DISABLE_AUTOMATIC_RETRIES.isTrue(config);
        if (disableAutomaticRetries) {
            clientBuilder.disableAutomaticRetries();
        }
        clientBuilder.setConnectionManager(this.httpClientConnectionManager);
        clientBuilder.setConnectionManagerShared(VitamRestEasyConfiguration.CONNECTION_MANAGER_SHARED.isTrue(config));
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        Object credentialsProvider = VitamRestEasyConfiguration.CREDENTIALS_PROVIDER.getObject(config);
        if (credentialsProvider instanceof CredentialsProvider) {
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if ((proxyUri = VitamRestEasyConfiguration.PROXY_URI.getObject(config)) != null) {
            String password;
            URI u = VitamApacheHttpClientEngine.getProxyUri(proxyUri);
            HttpHost proxy = new HttpHost(u.getHost(), u.getPort(), u.getScheme());
            String userName = VitamRestEasyConfiguration.PROXY_USERNAME.getString(config, null);
            if (userName != null && (password = VitamRestEasyConfiguration.PROXY_PASSWORD.getString(config, null)) != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(u.getHost(), u.getPort()), (Credentials)new UsernamePasswordCredentials(userName, password));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            clientBuilder.setProxy(proxy);
        }
        if (reqConfig != null) {
            RequestConfig.Builder reqConfigBuilder = RequestConfig.copy((RequestConfig)((RequestConfig)reqConfig));
            this.requestConfig = reqConfigBuilder.build();
        } else {
            this.requestConfig = requestConfigBuilder.build();
        }
        if (this.requestConfig.getCookieSpec() == null || !this.requestConfig.getCookieSpec().equals("ignoreCookies")) {
            this.cookieStore = new BasicCookieStore();
            clientBuilder.setDefaultCookieStore(this.cookieStore);
        } else {
            this.cookieStore = null;
        }
        clientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)MY_CONNECTION_REUSE_STRATEGY);
        clientBuilder.setKeepAliveStrategy(MY_KEEP_ALIVE_STRATEGY);
        clientBuilder.setDefaultRequestConfig(this.requestConfig);
        if (!VitamRestEasyConfiguration.CONTENTCOMPRESSIONENABLED.isTrue(config)) {
            clientBuilder.disableContentCompression();
        }
        this.connectTimeout = VitamRestEasyConfiguration.CONNECT_TIMEOUT.getInt(config, 1000);
        this.socketTimeout = VitamRestEasyConfiguration.READ_TIMEOUT.getInt(config, 1000);
        this.bufferSize = VitamRestEasyConfiguration.CHUNKED_ENCODING_SIZE.getInt(config, 8192);
        this.responseBufferSize = VitamRestEasyConfiguration.RECV_BUFFER_SIZE.getInt(config, 0);
        this.bufferingEnabled = "BUFFERED".equalsIgnoreCase(VitamRestEasyConfiguration.REQUEST_ENTITY_PROCESSING.getString(config, "CHUNKED"));
        this.httpClient = clientBuilder.build();
        this.closed = false;
        LOGGER.debug("{}", (Object)this);
    }

    public String toString() {
        return "connectTimeout: " + this.connectTimeout + " socketTimeout: " + this.socketTimeout + " bufferSize: " + this.bufferSize + " responseBufferSize: " + this.responseBufferSize + " bufferingEnabled: " + this.bufferingEnabled + " config: " + String.valueOf(this.config);
    }

    private static URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ProcessingException("WRONG_PROXY_URI_TYPE");
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public HostnameVerifier getHostnameVerifier() {
        return null;
    }

    public ClientResponse invoke(Invocation clientInvocation) {
        HttpUriRequest request = this.getUriHttpRequest((ClientInvocation)clientInvocation);
        VitamApacheHttpClientEngine.writeOutBoundHeaders(((ClientInvocation)clientInvocation).getHeaders(), request);
        try {
            Object context = VitamRestEasyConfiguration.CACHE_ENABLED.isTrue(this.config) ? HttpCacheContext.create() : HttpClientContext.create();
            final CloseableHttpResponse response = this.httpClient.execute(this.getHost(request), (HttpRequest)request, (HttpContext)context);
            if (VitamRestEasyConfiguration.CACHE_ENABLED.isTrue(this.config)) {
                CacheResponseStatus responseStatus = context.getCacheResponseStatus();
                switch (responseStatus) {
                    case CACHE_HIT: {
                        LOGGER.debug("A response was generated from the cache with no requests sent upstream");
                        break;
                    }
                    case CACHE_MODULE_RESPONSE: {
                        LOGGER.debug("The response was generated directly by the caching module");
                        break;
                    }
                    case CACHE_MISS: {
                        LOGGER.debug("The response came from an upstream server");
                        break;
                    }
                    case VALIDATED: {
                        LOGGER.debug("The response was generated from the cache after validating the entry with the origin server");
                    }
                }
            }
            ClientResponse responseContext = new ClientResponse(((ClientInvocation)clientInvocation).getClientConfiguration(), RESTEasyTracingLogger.empty()){
                InputStream stream;
                {
                    super(arg0, arg1);
                    this.stream = VitamApacheHttpClientEngine.this.getNativeInputStream(response);
                    this.setEntity(this.stream);
                }

                protected InputStream getInputStream() {
                    return this.stream;
                }

                protected void setInputStream(InputStream is) {
                    this.stream = is;
                }

                public void releaseConnection() throws IOException {
                    this.releaseConnection(true);
                }

                public void releaseConnection(boolean consumeInputStream) throws IOException {
                    try {
                        if (consumeInputStream) {
                            while (this.stream.read() > 0) {
                            }
                        }
                        this.stream.close();
                    }
                    finally {
                        StreamUtils.closeSilently((InputStream)response.getEntity().getContent());
                    }
                    response.close();
                }
            };
            responseContext.setProperties(((ClientInvocation)clientInvocation).getMutableProperties());
            responseContext.setStatus(response.getStatusLine().getStatusCode());
            responseContext.setHeaders(VitamApacheHttpClientEngine.extractHeaders((HttpResponse)response));
            responseContext.setClientConfiguration(((ClientInvocation)clientInvocation).getClientConfiguration());
            return responseContext;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private static CaseInsensitiveMap<String> extractHeaders(HttpResponse response) {
        CaseInsensitiveMap headers = new CaseInsensitiveMap();
        for (Header header : response.getAllHeaders()) {
            headers.add((Object)header.getName(), (Object)header.getValue());
        }
        return headers;
    }

    private HttpHost getHost(HttpUriRequest request) {
        return new HttpHost(request.getURI().getHost(), request.getURI().getPort(), request.getURI().getScheme());
    }

    private HttpUriRequest getUriHttpRequest(ClientInvocation clientInvocation) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.copy((RequestConfig)this.requestConfig);
        if (this.connectTimeout >= 0) {
            requestConfigBuilder.setConnectTimeout(this.connectTimeout);
        }
        if (this.socketTimeout >= 0) {
            requestConfigBuilder.setSocketTimeout(this.socketTimeout);
        }
        requestConfigBuilder.setRedirectsEnabled(true);
        HttpEntity entity = this.getHttpEntity(clientInvocation, this.bufferingEnabled, this.bufferSize);
        return RequestBuilder.create((String)clientInvocation.getMethod()).setUri(clientInvocation.getUri()).setConfig(requestConfigBuilder.build()).setEntity(entity).build();
    }

    private HttpEntity getHttpEntity(final ClientInvocation clientInvocation, final boolean bufferingEnabled, final int bufferSize) {
        final Object entity = clientInvocation.getEntity();
        if (entity == null) {
            return null;
        }
        AbstractHttpEntity httpEntity = new AbstractHttpEntity(){

            public boolean isRepeatable() {
                return false;
            }

            public long getContentLength() {
                return -1L;
            }

            public InputStream getContent() throws IOException, IllegalStateException {
                if (bufferingEnabled) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream(bufferSize);
                    this.writeTo((OutputStream)buffer);
                    return buffer.toInputStream();
                }
                if (entity instanceof InputStream) {
                    return (InputStream)entity;
                }
                return null;
            }

            public void writeTo(OutputStream outputStream) throws IOException {
                clientInvocation.setDelegatingOutputStream(new DelegatingOutputStream(outputStream));
                clientInvocation.writeRequestBody(outputStream);
            }

            public boolean isStreaming() {
                return !bufferingEnabled;
            }
        };
        if (bufferingEnabled) {
            try {
                return new BufferedHttpEntity((HttpEntity)httpEntity);
            }
            catch (IOException e) {
                throw new ProcessingException("ERROR_BUFFERING_ENTITY", (Throwable)e);
            }
        }
        return httpEntity;
    }

    private static void writeOutBoundHeaders(ClientRequestHeaders clientRequestHeaders, HttpUriRequest request) {
        for (Map.Entry e : clientRequestHeaders.asMap().entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (String value : (List)e.getValue()) {
                if (builder.length() == 0) {
                    builder.append(value);
                    continue;
                }
                builder.append(',').append(value);
            }
            String finalHeader = builder.toString();
            request.addHeader((String)e.getKey(), finalHeader);
        }
    }

    private InputStream createBufferedStream(InputStream is) {
        if (this.responseBufferSize == 0) {
            return is;
        }
        if (this.responseBufferSize < 0) {
            return new SelfExpandingBufferredInputStream(is, 32768);
        }
        return new BufferedInputStream(is, this.responseBufferSize);
    }

    private InputStream getNativeInputStream(final CloseableHttpResponse response) throws IOException {
        InputStream i;
        LOGGER.debug("{}", (Object)this);
        Object inputStream = response.getEntity() == null ? new NullInputStream(0L) : ((i = response.getEntity().getContent()).markSupported() ? i : this.createBufferedStream(i));
        return new FilterInputStream((InputStream)inputStream){

            @Override
            public void close() throws IOException {
                StreamUtils.closeSilently((InputStream)response.getEntity().getContent());
                super.close();
                response.close();
            }
        };
    }

    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        this.clean();
        this.closed = true;
    }

    private void clean() {
        this.cookieStore = null;
        this.requestConfig = null;
        this.httpClientConnectionManager = null;
        this.config = null;
        this.sslContext = null;
        this.httpClient = null;
    }

    static {
        MY_CONNECTION_REUSE_STRATEGY = new VitamConnectionReuseStrategy();
        MY_KEEP_ALIVE_STRATEGY = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException e) {
                    LOGGER.warn((Throwable)e);
                }
            }
            return VitamConfiguration.getMaxDelayUnusedConnection().intValue();
        };
    }

    @Contract(threading=ThreadingBehavior.IMMUTABLE)
    public static class VitamConnectionReuseStrategy
    implements ConnectionReuseStrategy {
        public static final VitamConnectionReuseStrategy INSTANCE = new VitamConnectionReuseStrategy();

        public boolean keepAlive(HttpResponse response, HttpContext context) {
            HeaderIterator headerIterator;
            ProtocolVersion ver;
            block17: {
                Args.notNull((Object)response, (String)"HTTP response");
                Args.notNull((Object)context, (String)"HTTP context");
                HttpRequest request = (HttpRequest)context.getAttribute("http.request");
                if (request != null) {
                    try {
                        BasicTokenIterator ti = new BasicTokenIterator(request.headerIterator("Connection"));
                        while (ti.hasNext()) {
                            String token = ti.nextToken();
                            if (!"Close".equalsIgnoreCase(token)) continue;
                            return false;
                        }
                    }
                    catch (ParseException px) {
                        return false;
                    }
                }
                ver = response.getStatusLine().getProtocolVersion();
                Header teh = response.getFirstHeader("Transfer-Encoding");
                if (teh != null) {
                    if (!"chunked".equalsIgnoreCase(teh.getValue())) {
                        return false;
                    }
                } else if (this.canResponseHaveBody(request, response)) {
                    Header[] clhs = response.getHeaders("Content-Length");
                    if (clhs.length == 1) {
                        Header clh = clhs[0];
                        try {
                            int contentLen = Integer.parseInt(clh.getValue());
                            if (contentLen < 0) {
                                return false;
                            }
                            break block17;
                        }
                        catch (NumberFormatException ex) {
                            return false;
                        }
                    }
                    return true;
                }
            }
            if (!(headerIterator = response.headerIterator("Connection")).hasNext()) {
                headerIterator = response.headerIterator("Proxy-Connection");
            }
            if (headerIterator.hasNext()) {
                try {
                    BasicTokenIterator ti = new BasicTokenIterator(headerIterator);
                    boolean keepalive = true;
                    while (ti.hasNext()) {
                        String token = ti.nextToken();
                        if (!"Close".equalsIgnoreCase(token)) continue;
                        return false;
                    }
                    return keepalive;
                }
                catch (ParseException px) {
                    return false;
                }
            }
            return !ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0);
        }

        protected TokenIterator createTokenIterator(HeaderIterator hit) {
            return new BasicTokenIterator(hit);
        }

        private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
            if (request != null && "HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
                return false;
            }
            int status = response.getStatusLine().getStatusCode();
            return status >= 202 && status != 204 && status != 304 && status != 205;
        }
    }
}

