/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.client;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientMock;
import fr.gouv.vitam.storage.engine.client.StorageClientRest;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class StorageClientFactory
extends VitamClientFactory<StorageClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "storage-client.conf";
    private static final StorageClientFactory STORAGE_CLIENT_FACTORY = new StorageClientFactory();
    public static final String RESOURCE_PATH = "/storage/v1";

    private StorageClientFactory() {
        super(StorageClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH);
    }

    public static StorageClientFactory getInstance() {
        return STORAGE_CLIENT_FACTORY;
    }

    public StorageClient getClient() {
        return switch (this.getVitamClientType()) {
            case VitamClientFactoryInterface.VitamClientType.MOCK -> new StorageClientMock();
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new StorageClientRest(this);
            default -> throw new IllegalArgumentException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_CLIENT_UNKNOWN, (Object[])new Object[0]));
        };
    }

    static final ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), ClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        }
        return configuration;
    }

    public static final void changeMode(ClientConfiguration configuration) {
        StorageClientFactory.getInstance().initialisation(configuration, StorageClientFactory.getInstance().getResourcePath());
    }

    static final void changeMode(String serviceUrl) {
        ParametersChecker.checkParameter((String)"Server Url can not be null", (String[])new String[]{serviceUrl});
        URI uri = URI.create(serviceUrl);
        ClientConfigurationImpl configuration = new ClientConfigurationImpl(uri.getHost(), uri.getPort());
        StorageClientFactory.changeMode((ClientConfiguration)configuration);
    }
}

