/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.security.internal.common.exception.PersonalCertificateException;
import fr.gouv.vitam.security.internal.common.model.PersonalCertificateModel;
import fr.gouv.vitam.security.internal.common.service.ParsedCertificate;
import fr.gouv.vitam.security.internal.common.service.X509PKIUtil;
import fr.gouv.vitam.security.internal.rest.repository.CertificateRepository;
import fr.gouv.vitam.security.internal.rest.repository.PersonalRepository;
import fr.gouv.vitam.security.internal.rest.service.SecurityService;
import java.security.cert.CertificateException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class PersonalCertificateService
extends SecurityService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PersonalCertificateService.class);
    private static final String INVALID_CERTIFICATE = "Invalid certificate";
    private static final String NO_CERTIFICATE_MESSAGE = "No certificate transmitted";
    private static final String PERSONAL_LOGBOOK_EVENT = "STP_PERSONAL_CERTIFICATE_CHECK";
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final PersonalRepository personalRepository;

    public PersonalCertificateService(LogbookOperationsClientFactory logbookOperationsClientFactory, PersonalRepository personalRepository) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.personalRepository = personalRepository;
    }

    public void createPersonalCertificateIfNotPresent(byte[] certificate) throws PersonalCertificateException, InvalidParseOperationException {
        ParsedCertificate parsedCertificate = ParsedCertificate.parseCertificate((byte[])certificate);
        if (this.findPersonalCertificateByHash(parsedCertificate.getCertificateHash()).isPresent()) {
            LOGGER.info("Personal certificate already exists {0}", (Object)parsedCertificate.getCertificateHash());
            return;
        }
        LOGGER.info("Personal certificate does not exist {0}. Creating it...", (Object)parsedCertificate.getCertificateHash());
        PersonalCertificateModel personalModel = new PersonalCertificateModel();
        personalModel.setId(GUIDFactory.newGUID().toString());
        personalModel.setCertificate(parsedCertificate.getRawCertificate());
        personalModel.setSubjectDN(parsedCertificate.getX509Certificate().getSubjectDN().getName());
        personalModel.setIssuerDN(parsedCertificate.getX509Certificate().getIssuerDN().getName());
        personalModel.setSerialNumber(String.valueOf(parsedCertificate.getX509Certificate().getSerialNumber()));
        personalModel.setCertificateHash(parsedCertificate.getCertificateHash());
        personalModel.setExpirationDate(LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.fromDate((Date)parsedCertificate.getX509Certificate().getNotAfter())));
        this.personalRepository.createPersonalCertificate(personalModel);
    }

    public void deletePersonalCertificateIfPresent(byte[] certificate) throws PersonalCertificateException {
        ParsedCertificate parsedCertificate = ParsedCertificate.parseCertificate((byte[])certificate);
        this.personalRepository.deletePersonalCertificate(parsedCertificate.getCertificateHash());
    }

    public void checkPersonalCertificateExistence(byte[] certificate, String permission) throws LogbookClientException, InvalidParseOperationException, PersonalCertificateException {
        ParsedCertificate parsedCertificate;
        if (certificate == null) {
            this.createNoPersonalCertificateLogbook(permission);
            throw new PersonalCertificateException(NO_CERTIFICATE_MESSAGE);
        }
        try {
            parsedCertificate = ParsedCertificate.parseCertificate((byte[])certificate);
        }
        catch (PersonalCertificateException e) {
            this.createInvalidPersonalCertificateLogbook(permission);
            throw e;
        }
        Optional<PersonalCertificateModel> model = this.findPersonalCertificateByHash(parsedCertificate.getCertificateHash());
        if (model.isPresent()) {
            LOGGER.debug("Access OK for permission {0} with valid personal certificate {1}", (Object)permission, (Object)parsedCertificate.getCertificateHash());
            return;
        }
        this.createInvalidPersonalCertificateLogbook(parsedCertificate, permission);
        throw new PersonalCertificateException(INVALID_CERTIFICATE);
    }

    private Optional<PersonalCertificateModel> findPersonalCertificateByHash(String certificateHash) throws InvalidParseOperationException, PersonalCertificateException {
        Optional<PersonalCertificateModel> personalCertificateModelOptional = this.personalRepository.findPersonalCertificateByHash(certificateHash);
        if (personalCertificateModelOptional.isPresent()) {
            try {
                X509PKIUtil.parseX509Certificate((byte[])personalCertificateModelOptional.get().getCertificate());
            }
            catch (CertificateException e) {
                throw new PersonalCertificateException(INVALID_CERTIFICATE);
            }
        }
        return personalCertificateModelOptional;
    }

    public List<PersonalCertificateModel> findAllPersonalCertificates() throws InvalidParseOperationException {
        return this.personalRepository.findAll();
    }

    private void createNoPersonalCertificateLogbook(String permission) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException, InvalidParseOperationException {
        LogbookOperationParameters logbookParameters = this.getLogbookParametersKo();
        ObjectNode evDetData = JsonHandler.createObjectNode();
        ObjectNode msg = JsonHandler.createObjectNode();
        msg.put("Certificate", "No certificate");
        msg.put("Permission", permission);
        evDetData.set("Context", (JsonNode)msg);
        String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)evDetData);
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
        this.logbookOperationsClientFactory.getClient().create(new LogbookOperationParameters[]{logbookParameters});
    }

    private void createInvalidPersonalCertificateLogbook(String permission) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException, InvalidParseOperationException {
        LogbookOperationParameters logbookParameters = this.getLogbookParametersKo();
        ObjectNode evDetData = JsonHandler.createObjectNode();
        ObjectNode msg = JsonHandler.createObjectNode();
        msg.put("Certificate", INVALID_CERTIFICATE);
        msg.put("Permission", permission);
        evDetData.set("Context", (JsonNode)msg);
        String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)evDetData);
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
        this.logbookOperationsClientFactory.getClient().create(new LogbookOperationParameters[]{logbookParameters});
    }

    private void createInvalidPersonalCertificateLogbook(ParsedCertificate parsedCertificate, String permission) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException, InvalidParseOperationException {
        LogbookOperationParameters logbookParameters = this.getLogbookParametersKo();
        ObjectNode evDetData = JsonHandler.createObjectNode();
        ObjectNode msg = JsonHandler.createObjectNode();
        msg.put("CertificateSn", parsedCertificate.getX509Certificate().getSerialNumber().toString());
        msg.put("CertificateSubjectDN", parsedCertificate.getX509Certificate().getSubjectDN().toString());
        msg.put("Permission", permission);
        evDetData.set("Context", (JsonNode)msg);
        String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)evDetData);
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
        this.logbookOperationsClientFactory.getClient().create(new LogbookOperationParameters[]{logbookParameters});
    }

    private LogbookOperationParameters getLogbookParametersKo() {
        GUID eip = GUIDFactory.newGUID();
        return LogbookParameterHelper.newLogbookOperationParameters((GUID)eip, (String)PERSONAL_LOGBOOK_EVENT, (GUID)eip, (LogbookTypeProcess)LogbookTypeProcess.CHECK, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)PERSONAL_LOGBOOK_EVENT, (StatusCode)StatusCode.KO), (GUID)eip);
    }

    @Override
    public CertificateRepository getRepository() {
        return this.personalRepository;
    }
}

