/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.service;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.security.internal.common.model.CertificateBaseModel;
import fr.gouv.vitam.security.internal.common.model.CertificateStatus;
import fr.gouv.vitam.security.internal.common.service.CRLService;
import fr.gouv.vitam.security.internal.common.service.X509PKIUtil;
import fr.gouv.vitam.security.internal.rest.repository.CertificateCRLCheckStateUpdater;
import fr.gouv.vitam.security.internal.rest.repository.IdentityRepository;
import fr.gouv.vitam.security.internal.rest.repository.PersonalRepository;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bson.Document;

public class CRLServiceImpl
implements CRLService {
    private final IdentityRepository identityRepository;
    private final PersonalRepository personalRepository;
    private final AlertService alertService;

    public CRLServiceImpl(IdentityRepository identityRepository, PersonalRepository personalRepository) {
        this(identityRepository, personalRepository, (AlertService)new AlertServiceImpl());
    }

    public CRLServiceImpl(IdentityRepository identityRepository, PersonalRepository personalRepository, AlertService alertService) {
        this.identityRepository = identityRepository;
        this.personalRepository = personalRepository;
        this.alertService = alertService;
    }

    public void checkIdentityWithCRL(byte[] crlCert) throws CertificateException, InvalidParseOperationException, CRLException {
        X509CRL crl = X509PKIUtil.parseX509CRLCertificate((byte[])crlCert);
        if (!X509PKIUtil.validateX509CRL((X509CRL)crl)) {
            String alertMessage = "CRL issued by " + crl.getIssuerDN().getName() + " has invalid dates (issued after now or expired before now) : thisUpdate=" + String.valueOf(crl.getThisUpdate()) + " ,nextUpdate=" + String.valueOf(crl.getNextUpdate());
            this.alertService.createAlert(alertMessage);
            throw new CRLException(alertMessage);
        }
        this.checkAndUpdateCertificatesByType(crl, this.identityRepository);
        this.checkAndUpdateCertificatesByType(crl, this.personalRepository);
    }

    private void checkAndUpdateCertificatesByType(X509CRL crl, CertificateCRLCheckStateUpdater<?> crlCheckerRepositoryImplementer) throws InvalidParseOperationException, CertificateException {
        FindIterable<Document> crlCAIdentitiesDocs = crlCheckerRepositoryImplementer.findCertificate(crl.getIssuerDN().getName(), CertificateStatus.VALID);
        MongoCursor crlCAIdentities = crlCAIdentitiesDocs.iterator();
        ArrayList<String> crtRevocatedList = new ArrayList<String>();
        ArrayList<String> crtExpiredList = new ArrayList<String>();
        while (crlCAIdentities.hasNext()) {
            CertificateBaseModel certificateModel = (CertificateBaseModel)BsonHelper.fromDocumentToObject((Document)((Document)crlCAIdentities.next()), crlCheckerRepositoryImplementer.getEntityModelType());
            try {
                X509Certificate cert = X509PKIUtil.parseX509Certificate((byte[])certificateModel.getCertificate());
                if (!crl.isRevoked(cert)) continue;
                crtRevocatedList.add(certificateModel.getId());
                this.alertService.createAlert(VitamLogLevel.WARN, "Certificate " + certificateModel.getSubjectDN() + " was revoked by CRL");
            }
            catch (CertificateExpiredException e) {
                crtExpiredList.add(certificateModel.getId());
                this.alertService.createAlert(VitamLogLevel.WARN, "Certificate " + certificateModel.getSubjectDN() + " is expired");
            }
        }
        if (!crtExpiredList.isEmpty()) {
            crlCheckerRepositoryImplementer.updateCertificateState(crtExpiredList, CertificateStatus.EXPIRED);
        }
        if (!crtRevocatedList.isEmpty()) {
            crlCheckerRepositoryImplementer.updateCertificateState(crtRevocatedList, CertificateStatus.REVOKED);
        }
    }
}

