/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.server;

import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.mongodb.client.MongoClient;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.database.server.mongodb.SimpleMongoDBAccess;
import fr.gouv.vitam.common.server.HeaderIdContainerFilter;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.server.application.configuration.DefaultVitamApplicationConfiguration;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.security.internal.filter.BasicAuthenticationFilter;
import fr.gouv.vitam.security.internal.rest.mapper.CertificateExceptionMapper;
import fr.gouv.vitam.security.internal.rest.mapper.IllegalArgumentExceptionMapper;
import fr.gouv.vitam.security.internal.rest.repository.IdentityRepository;
import fr.gouv.vitam.security.internal.rest.repository.PersonalRepository;
import fr.gouv.vitam.security.internal.rest.resource.AdminCRLResource;
import fr.gouv.vitam.security.internal.rest.resource.AdminIdentityResource;
import fr.gouv.vitam.security.internal.rest.resource.AdminPersonalCertificateResource;
import fr.gouv.vitam.security.internal.rest.resource.AdminSecurityDataMigrationResource;
import fr.gouv.vitam.security.internal.rest.server.InternalSecurityConfiguration;
import fr.gouv.vitam.security.internal.rest.service.CRLServiceImpl;
import fr.gouv.vitam.security.internal.rest.service.IdentityService;
import fr.gouv.vitam.security.internal.rest.service.PersonalCertificateService;
import fr.gouv.vitam.security.internal.rest.service.migration.SecurityDataMigrationRepository;
import fr.gouv.vitam.security.internal.rest.service.migration.SecurityDataMigrationService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class AdminIdentityApplication
extends Application {
    private final AdminApplication adminApplication;
    private Set<Object> singletons;
    private final String configurationFile;

    public AdminIdentityApplication(@Context ServletConfig servletConfig) {
        this.configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        this.adminApplication = new AdminApplication();
    }

    public Set<Object> getSingletons() {
        if (this.singletons == null) {
            this.singletons = this.adminApplication.getSingletons();
            try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)this.configurationFile);){
                InternalSecurityConfiguration configuration = (InternalSecurityConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, InternalSecurityConfiguration.class));
                MongoClient mongoClient = MongoDbAccess.createMongoClient((DbConfiguration)configuration);
                SimpleMongoDBAccess mongoDbAccess = new SimpleMongoDBAccess(mongoClient, configuration.getDbName());
                IdentityRepository identityRepository = new IdentityRepository((MongoDbAccess)mongoDbAccess);
                IdentityService identityService = new IdentityService(identityRepository);
                this.singletons.add(new AdminIdentityResource(identityService));
                PersonalRepository personalRepository = new PersonalRepository((MongoDbAccess)mongoDbAccess);
                PersonalCertificateService personalCertificateService = new PersonalCertificateService(LogbookOperationsClientFactory.getInstance(), personalRepository);
                this.singletons.add(new AdminPersonalCertificateResource(personalCertificateService));
                CRLServiceImpl crlService = new CRLServiceImpl(identityRepository, personalRepository);
                this.singletons.add(new AdminCRLResource(crlService));
                SecurityDataMigrationRepository securityDataMigrationRepository = new SecurityDataMigrationRepository((MongoDbAccess)mongoDbAccess);
                SecurityDataMigrationService securityDataMigrationService = new SecurityDataMigrationService(securityDataMigrationRepository);
                this.singletons.add(new AdminSecurityDataMigrationResource(securityDataMigrationService));
                this.singletons.add(new BasicAuthenticationFilter((DefaultVitamApplicationConfiguration)configuration));
                this.singletons.add(new CertificateExceptionMapper());
                this.singletons.add(new IllegalArgumentExceptionMapper());
                this.singletons.add(new HeaderIdContainerFilter());
                this.singletons.add(new JsonParseExceptionMapper());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.singletons;
    }
}

