/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.resource;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.security.internal.rest.service.migration.SecurityDataMigrationService;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/api/security")
@Tag(name="Security")
public class AdminSecurityDataMigrationResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminSecurityDataMigrationResource.class);
    private final String MIGRATION_URI = "/migration";
    private final String MIGRATION_STATUS_URI = "/migration/status";
    private final SecurityDataMigrationService securityDataMigrationService;

    @VisibleForTesting
    public AdminSecurityDataMigrationResource(SecurityDataMigrationService securityDataMigrationService) {
        this.securityDataMigrationService = securityDataMigrationService;
    }

    @Path(value="/migration")
    @POST
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response startSecurityDataMigration() {
        try {
            boolean started = this.securityDataMigrationService.tryStartMongoDataUpdate();
            if (started) {
                LOGGER.info("Security migration started successfully");
                return Response.accepted((Object)new ResponseMessage("OK")).build();
            }
            LOGGER.warn("Security migration already in progress");
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ResponseMessage("Security data migration already in progress")).build();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during security data migration", (Throwable)e);
            return Response.serverError().entity((Object)new ResponseMessage(e.getMessage())).build();
        }
    }

    @Path(value="/migration/status")
    @GET
    @Produces(value={"application/json"})
    public Response isMigrationInProgress() {
        try {
            boolean started = this.securityDataMigrationService.isMongoDataUpdateInProgress();
            if (started) {
                LOGGER.info("Security migration still in progress");
                return Response.ok((Object)new ResponseMessage("Security migration in progress")).build();
            }
            LOGGER.info("No active security migration");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ResponseMessage("No active security migration")).build();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during security data migration", (Throwable)e);
            return Response.serverError().entity((Object)new ResponseMessage(e.getMessage())).build();
        }
    }

    public static class ResponseMessage {
        private String message;

        public ResponseMessage(String message) {
            this.message = message;
        }

        public ResponseMessage() {
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

