/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.retryable;

import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.retryable.Retryable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class RetryableParameters {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(Retryable.class);
    private final int nbRetry;
    private final int firstAttemptWaitingTime;
    private final int waitingTime;
    private final int randomRangeSleep;
    private final TimeUnit timeUnit;
    private final Consumer<String> log;

    public RetryableParameters(int nbRetry, int firstAttemptWaitingTime, int waitingTime, int randomRangeSleep, TimeUnit timeUnit, VitamLogLevel level) {
        this.nbRetry = nbRetry;
        this.firstAttemptWaitingTime = firstAttemptWaitingTime;
        this.waitingTime = waitingTime;
        this.randomRangeSleep = randomRangeSleep;
        this.timeUnit = timeUnit;
        this.log = s -> LOGGER.log(level, (String)s);
    }

    public RetryableParameters(int nbRetry, int firstAttemptWaitingTime, int waitingTime, int randomRangeSleep, TimeUnit timeUnit) {
        this.nbRetry = nbRetry;
        this.firstAttemptWaitingTime = firstAttemptWaitingTime;
        this.waitingTime = waitingTime;
        this.randomRangeSleep = randomRangeSleep;
        this.timeUnit = timeUnit;
        this.log = s -> LOGGER.log(VitamLogLevel.ERROR, (String)s);
    }

    public int getNbRetry() {
        return this.nbRetry;
    }

    public int getFirstAttemptWaitingTime() {
        return this.firstAttemptWaitingTime;
    }

    public int getWaitingTime() {
        return this.waitingTime;
    }

    public int getRandomRangeSleep() {
        return this.randomRangeSleep;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Consumer<String> getLog() {
        return this.log;
    }
}

