/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.objectgroup;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.objectgroup.FileInfoModel;
import fr.gouv.vitam.common.model.objectgroup.FormatIdentificationModel;
import fr.gouv.vitam.common.model.objectgroup.MetadataModel;
import fr.gouv.vitam.common.model.objectgroup.PersistentIdentifierModel;
import fr.gouv.vitam.common.model.objectgroup.PhysicalDimensionsModel;
import fr.gouv.vitam.common.model.objectgroup.StorageJson;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class VersionsModel {
    public static final String ID = "#id";
    public static final String DATA_OBJECT_VERSION = "DataObjectVersion";
    public static final String DATA_OBJECT_GROUP_ID = "DataObjectGroupId";
    public static final String FORMAT_IDENTIFICATION = "FormatIdentification";
    public static final String FILE_INFO = "FileInfo";
    public static final String METADATA = "Metadata";
    public static final String SIZE = "Size";
    public static final String URI = "Uri";
    public static final String MESSAGE_DIGEST = "MessageDigest";
    public static final String ALGORITHM = "Algorithm";
    public static final String STORAGE = "#storage";
    public static final String PHYSICAL_DIMENSIONS = "PhysicalDimensions";
    public static final String PHYSICAL_ID = "PhysicalId";
    public static final String OTHER_METADATA = "OtherMetadata";
    public static final String OPI = "#opi";
    public static final String DATA_OBJECT_PROFILE = "DataObjectProfile";
    public static final String MANAGEMENT_CONTRACT_ID = "#managementContractId";
    public static final String DATA_OBJECT_USE = "DataObjectUse";
    public static final String DATA_OBJECT_NUMBER = "DataObjectNumber";
    public static final String PERSISTENT_IDENTIFIER = "PersistentIdentifier";
    @JsonProperty(value="#id")
    private String id;
    @JsonProperty(value="DataObjectVersion")
    private String dataObjectVersion;
    @JsonIgnore
    private final Map<String, Object> any = new HashMap<String, Object>();
    @JsonProperty(value="DataObjectGroupId")
    private String dataObjectGroupId;
    @JsonProperty(value="FormatIdentification")
    private FormatIdentificationModel formatIdentification;
    @JsonProperty(value="FileInfo")
    private FileInfoModel fileInfoModel;
    @JsonProperty(value="Metadata")
    private MetadataModel metadata;
    @JsonProperty(value="Size")
    private long size;
    @JsonProperty(value="Uri")
    private String uri;
    @JsonProperty(value="MessageDigest")
    private String messageDigest;
    @JsonProperty(value="Algorithm")
    private String algorithm;
    @JsonProperty(value="#storage")
    private StorageJson storage;
    @JsonProperty(value="PhysicalDimensions")
    private PhysicalDimensionsModel physicalDimensionsModel;
    @JsonProperty(value="PhysicalId")
    private String physicalId;
    @JsonProperty(value="OtherMetadata")
    private Map<String, Object> otherMetadata = new LinkedHashMap<String, Object>();
    @JsonProperty(value="#opi")
    private String opi;
    @JsonProperty(value="DataObjectProfile")
    private String dataObjectProfile;
    @JsonProperty(value="#managementContractId")
    private String managementContractId;
    @JsonProperty(value="DataObjectUse")
    private String dataObjectUse;
    @JsonProperty(value="DataObjectNumber")
    private Integer dataObjectNumber;
    @JsonProperty(value="PersistentIdentifier")
    private List<PersistentIdentifierModel> persistentIdentifier;

    @JsonAnyGetter
    public Map<String, Object> getAny() {
        return this.any;
    }

    @JsonAnySetter
    public void setAny(String key, Object value) {
        this.any.put(key, value);
    }

    public Map<String, Object> getOtherMetadata() {
        return this.otherMetadata;
    }

    public void setOtherMetadata(Map<String, Object> otherMetadata) {
        this.otherMetadata = otherMetadata;
    }

    public String getPhysicalId() {
        return this.physicalId;
    }

    public void setPhysicalId(String physicalId) {
        this.physicalId = physicalId;
    }

    public PhysicalDimensionsModel getPhysicalDimensionsModel() {
        return this.physicalDimensionsModel;
    }

    public void setPhysicalDimensionsModel(PhysicalDimensionsModel physicalDimensionsModel) {
        this.physicalDimensionsModel = physicalDimensionsModel;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDataObjectVersion() {
        return this.dataObjectVersion;
    }

    public void setDataObjectVersion(String dataObjectVersion) {
        this.dataObjectVersion = dataObjectVersion;
    }

    public String getDataObjectProfile() {
        return this.dataObjectProfile;
    }

    public void setDataObjectProfile(String dataObjectProfile) {
        this.dataObjectProfile = dataObjectProfile;
    }

    public FormatIdentificationModel getFormatIdentification() {
        return this.formatIdentification;
    }

    public void setFormatIdentification(FormatIdentificationModel formatIdentification) {
        this.formatIdentification = formatIdentification;
    }

    public FileInfoModel getFileInfoModel() {
        return this.fileInfoModel;
    }

    public void setFileInfoModel(FileInfoModel fileInfoModel) {
        this.fileInfoModel = fileInfoModel;
    }

    public String getDataObjectGroupId() {
        return this.dataObjectGroupId;
    }

    public void setDataObjectGroupId(String dataObjectGroupId) {
        this.dataObjectGroupId = dataObjectGroupId;
    }

    public MetadataModel getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataModel metadata) {
        this.metadata = metadata;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getMessageDigest() {
        return this.messageDigest;
    }

    public void setMessageDigest(String messageDigest) {
        this.messageDigest = messageDigest;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public StorageJson getStorage() {
        return this.storage;
    }

    public void setStorage(StorageJson storage) {
        this.storage = storage;
    }

    public String getOpi() {
        return this.opi;
    }

    public void setOpi(String opi) {
        this.opi = opi;
    }

    public String getDataObjectUse() {
        return this.dataObjectUse;
    }

    public void setDataObjectUse(String dataObjectUse) {
        this.dataObjectUse = dataObjectUse;
    }

    public Integer getDataObjectNumber() {
        return this.dataObjectNumber;
    }

    public void setDataObjectNumber(Integer dataObjectNumber) {
        this.dataObjectNumber = dataObjectNumber;
    }

    public List<PersistentIdentifierModel> getPersistentIdentifier() {
        return this.persistentIdentifier;
    }

    public void setPersistentIdentifier(List<PersistentIdentifierModel> persistentIdentifier) {
        this.persistentIdentifier = persistentIdentifier;
    }

    public String getManagementContractId() {
        return this.managementContractId;
    }

    public void setManagementContractId(String managementContractId) {
        this.managementContractId = managementContractId;
    }

    @JsonIgnore
    public int getVersion() {
        return Integer.parseInt(this.dataObjectVersion.split("_")[1]);
    }

    @JsonIgnore
    public DataObjectVersionType getQualifier() {
        return DataObjectVersionType.fromName(this.dataObjectVersion.split("_")[0]);
    }

    public String toString() {
        return "VersionsModel{id='" + this.id + "', dataObjectVersion='" + this.dataObjectVersion + "', dataObjectProfile='" + this.dataObjectProfile + "', dataObjectGroupId='" + this.dataObjectGroupId + "', formatIdentification=" + String.valueOf(this.formatIdentification) + ", fileInfoModel=" + String.valueOf(this.fileInfoModel) + ", metadata=" + String.valueOf(this.metadata) + ", size=" + this.size + ", uri='" + this.uri + "', messageDigest='" + this.messageDigest + "', algorithm='" + this.algorithm + "', storage=" + String.valueOf(this.storage) + ", physicalDimensionsModel=" + String.valueOf(this.physicalDimensionsModel) + ", physicalId='" + this.physicalId + "', otherMetadata=" + String.valueOf(this.otherMetadata) + ", opi='" + this.opi + "', dataObjectNumber='" + this.dataObjectNumber + "', dataObjectUse='" + this.dataObjectUse + "', persistentIdentifiers='" + String.valueOf(this.persistentIdentifier) != null ? "" : this.persistentIdentifier.toString() + "', any=" + String.valueOf(this.any) + "}";
    }
}

