/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.administration.preservation;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.administration.ActionTypePreservation;
import fr.gouv.vitam.common.model.administration.preservation.DefaultGriffin;
import fr.gouv.vitam.common.model.administration.preservation.GriffinByFormat;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class PreservationScenarioModel {
    private static final String TAG_DESCRIPTION = "Description";
    private static final String TAG_NAME = "Name";
    public static final String TAG_IDENTIFIER = "Identifier";
    public static final String TAG_CREATION_DATE = "CreationDate";
    public static final String TAG_LAST_UPDATE = "LastUpdate";
    private static final String TAG_ACTION_LIST = "ActionList";
    private static final String TAG_GRIFFIN_BY_FORMAT = "GriffinByFormat";
    private static final String TAG_DEFAULT_GRIFFIN = "DefaultGriffin";
    @JsonProperty(value="#id")
    @JsonAlias(value={"_id"})
    private String id;
    @JsonProperty(value="#tenant")
    @JsonAlias(value={"_tenant"})
    private Integer tenant;
    @JsonProperty(value="#version")
    @JsonAlias(value={"_version"})
    private Integer version;
    @NotEmpty(message="this field can not be empty")
    @JsonProperty(value="Name")
    private @NotEmpty(message="this field can not be empty") String name;
    @NotEmpty(message="this field can not be empty")
    @JsonProperty(value="Identifier")
    private @NotEmpty(message="this field can not be empty") String identifier;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="CreationDate")
    private String creationDate;
    @JsonProperty(value="LastUpdate")
    private String lastUpdate;
    @NotEmpty(message="this field can not be empty")
    @JsonProperty(value="ActionList")
    private @NotEmpty(message="this field can not be empty") List<ActionTypePreservation> actionList;
    @Valid
    @JsonProperty(value="GriffinByFormat")
    private List<GriffinByFormat> griffinByFormat;
    @JsonProperty(value="DefaultGriffin")
    @Valid
    private DefaultGriffin defaultGriffin;

    public PreservationScenarioModel() {
    }

    public PreservationScenarioModel(@NotEmpty String name, @NotEmpty String identifier, @NotEmpty List<ActionTypePreservation> actionList, @NotEmpty List<GriffinByFormat> griffinByFormat, @NotEmpty DefaultGriffin defaultGriffin) {
        this.name = name;
        this.identifier = identifier;
        this.actionList = actionList;
        this.griffinByFormat = griffinByFormat;
        this.defaultGriffin = defaultGriffin;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getTenant() {
        return this.tenant;
    }

    public void setTenant(Integer tenant) {
        this.tenant = tenant;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public List<ActionTypePreservation> getActionList() {
        return this.actionList;
    }

    public void setActionList(List<ActionTypePreservation> actionList) {
        this.actionList = actionList;
    }

    public List<GriffinByFormat> getGriffinByFormat() {
        if (this.griffinByFormat == null) {
            return Collections.emptyList();
        }
        return this.griffinByFormat;
    }

    public void setGriffinByFormat(List<GriffinByFormat> griffinByFormat) {
        this.griffinByFormat = griffinByFormat;
    }

    public DefaultGriffin getDefaultGriffin() {
        return this.defaultGriffin;
    }

    public void setDefaultGriffin(DefaultGriffin defaultGriffin) {
        this.defaultGriffin = defaultGriffin;
    }

    @JsonIgnore
    public Optional<String> getGriffinIdentifierByFormat(String format) {
        Optional<GriffinByFormat> griffin = this.getGriffinByFormat(format);
        return griffin.map(GriffinByFormat::getGriffinIdentifier);
    }

    @JsonIgnore
    public Optional<GriffinByFormat> getGriffinByFormat(String format) {
        GriffinByFormat griffinByFormat = this.getGriffinByFormat().stream().filter(element -> element.getFormatList().contains(format)).findFirst().orElse(this.defaultGriffin == null ? null : new GriffinByFormat(this.defaultGriffin));
        return Optional.ofNullable(griffinByFormat);
    }

    @JsonIgnore
    public Set<String> getAllGriffinIdentifiers() {
        Set<String> identifiers = this.getGriffinByFormat().stream().map(GriffinByFormat::getGriffinIdentifier).collect(Collectors.toSet());
        if (this.defaultGriffin != null) {
            identifiers.add(this.defaultGriffin.getGriffinIdentifier());
        }
        return identifiers;
    }

    public String toString() {
        return "PreservationScenarioModel{id='" + this.id + "', tenant=" + this.tenant + ", version=" + this.version + ", name='" + this.name + "', identifier='" + this.identifier + "', description='" + this.description + "', creationDate='" + this.creationDate + "', lastUpdate='" + this.lastUpdate + "', actionList=" + String.valueOf(this.actionList) + ", griffinByFormat=" + String.valueOf(this.griffinByFormat) + ", defaultGriffin=" + String.valueOf(this.defaultGriffin) + "}";
    }
}

