/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.administration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ArchiveUnitProfileSedaVersion {
    VERSION_2_1("2.1"),
    VERSION_2_2("2.2"),
    VERSION_2_3("2.3");

    private static final Map<String, ArchiveUnitProfileSedaVersion> VERSION_MAP;
    private final String version;

    private ArchiveUnitProfileSedaVersion(String version) {
        this.version = version;
    }

    @JsonValue
    public String getVersion() {
        return this.version;
    }

    @JsonCreator
    public static ArchiveUnitProfileSedaVersion forVersion(String version) throws IllegalArgumentException {
        if (version == null) {
            return VERSION_2_3;
        }
        return Optional.ofNullable(VERSION_MAP.get(version)).orElseThrow(() -> new IllegalArgumentException("Cannot find ArchiveUnitProfileSedaVersion " + version));
    }

    static {
        VERSION_MAP = Stream.of(ArchiveUnitProfileSedaVersion.values()).collect(Collectors.toMap(ArchiveUnitProfileSedaVersion::getVersion, Function.identity()));
    }
}

