/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import javax.ws.rs.core.Response;

public enum StatusCode {
    UNKNOWN,
    STARTED,
    ALREADY_EXECUTED,
    OK,
    WARNING,
    KO,
    FATAL;


    public int getStatusLevel() {
        return this.ordinal();
    }

    public boolean isGreaterOrEqualToWarn() {
        return this.compareTo(WARNING) >= 0;
    }

    public boolean isGreaterOrEqualToKo() {
        return this.compareTo(KO) >= 0;
    }

    public boolean isGreaterOrEqualToFatal() {
        return this.compareTo(FATAL) >= 0;
    }

    public boolean isGreaterOrEqualToStarted() {
        return this.compareTo(STARTED) >= 0;
    }

    public Response.Status getEquivalentHttpStatus() {
        switch (this) {
            case OK: {
                return Response.Status.OK;
            }
            case ALREADY_EXECUTED: {
                return Response.Status.NO_CONTENT;
            }
            case WARNING: {
                return Response.Status.PARTIAL_CONTENT;
            }
            case KO: {
                return Response.Status.BAD_REQUEST;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }
}

