/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.model.DatabaseCursor;
import fr.gouv.vitam.common.model.FacetResult;
import fr.gouv.vitam.common.model.QueryDTO;
import fr.gouv.vitam.common.model.QueryFilter;
import fr.gouv.vitam.common.model.RequestResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public final class RequestResponseOK<T>
extends RequestResponse<T> {
    private static final String TAG_HITS = "$hits";
    public static final String TAG_RESULTS = "$results";
    public static final String TAG_FACET_RESULTS = "$facetResults";
    public static final String TAG_CONTEXT = "$context";
    public static final String TAG_HISTORY = "$history";
    @JsonProperty(value="$hits")
    private DatabaseCursor hits;
    @JsonProperty(value="$results")
    private final List<T> results;
    @JsonProperty(value="$facetResults")
    private final List<FacetResult> facetResults;
    @JsonProperty(value="$context")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private JsonNode query;
    @JsonProperty(value="$history")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private JsonNode history;

    public RequestResponseOK() {
        this((JsonNode)JsonHandler.createObjectNode());
    }

    public RequestResponseOK(JsonNode query) {
        this.query = query;
        int offset = 0;
        int limit = 0;
        try {
            QueryFilter queryFilter;
            QueryDTO queryDTO = JsonHandler.getFromJsonNode(query, QueryDTO.class);
            if (null != queryDTO && null != (queryFilter = queryDTO.getFilter())) {
                offset = queryFilter.getOffset();
                limit = queryFilter.getLimit();
            }
        }
        catch (Exception e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
        this.hits = new DatabaseCursor(0L, offset, limit);
        this.results = new ArrayList<T>();
        this.facetResults = new ArrayList<FacetResult>();
    }

    public RequestResponseOK(JsonNode query, List<T> results, int total) {
        this(query);
        this.results.addAll(results);
        this.hits = new DatabaseCursor(total, this.hits.getOffset(), this.hits.getLimit(), results.size());
    }

    public RequestResponseOK(JsonNode query, List<T> results, int total, String scrollId) {
        this(query, results, total);
        this.hits = new DatabaseCursor(total, this.hits.getOffset(), this.hits.getLimit(), results.size(), scrollId);
    }

    public RequestResponseOK<T> addResult(T result) {
        ParametersChecker.checkParameter("Result is a mandatory parameter", result);
        this.results.add(result);
        this.hits.setSize(this.hits.getSize() + 1L);
        this.hits.setTotal(this.hits.getSize());
        return this;
    }

    public RequestResponseOK<T> addAllResults(List<T> resultList) {
        ParametersChecker.checkParameter("Result list is a mandatory parameter", resultList);
        this.results.addAll(resultList);
        this.hits.setSize(this.hits.getSize() + (long)resultList.size());
        this.hits.setTotal(this.hits.getSize());
        return this;
    }

    public RequestResponseOK<T> addFacetResult(FacetResult facetResult) {
        ParametersChecker.checkParameter("facetResult is a mandatory parameter", facetResult);
        this.facetResults.add(facetResult);
        return this;
    }

    public RequestResponseOK<T> addAllFacetResults(List<FacetResult> facetResultList) {
        ParametersChecker.checkParameter("facetResult list is a mandatory parameter", this.facetResults);
        this.facetResults.addAll(facetResultList);
        return this;
    }

    public DatabaseCursor getHits() {
        return this.hits;
    }

    public RequestResponseOK<T> setHits(DatabaseCursor hits) {
        if (hits != null) {
            this.hits = hits;
        }
        return this;
    }

    public RequestResponseOK<T> setHits(long total, int offset, int limit) {
        this.hits = new DatabaseCursor(total, offset, limit, total);
        return this;
    }

    public RequestResponseOK<T> setHits(long total, int offset, int limit, int size, String scrollId) {
        this.hits = new DatabaseCursor(total, offset, limit, size, scrollId);
        return this;
    }

    public RequestResponseOK<T> setHits(long total, int offset, int limit, int size) {
        this.hits = new DatabaseCursor(total, offset, limit, size);
        return this;
    }

    public RequestResponseOK<T> setTotal(long total) {
        if (this.hits != null) {
            this.hits.setTotal(total);
        }
        return this;
    }

    public RequestResponseOK<T> setScrollId(String scrollId) {
        if (this.hits != null) {
            this.hits.setScrollId(scrollId);
        }
        return this;
    }

    public List<FacetResult> getFacetResults() {
        return this.facetResults;
    }

    public List<T> getResults() {
        return this.results;
    }

    public JsonNode getQuery() {
        return this.query;
    }

    public JsonNode getHistory() {
        return this.history;
    }

    @JsonIgnore
    public T getFirstResult() {
        if (this.results != null && !this.results.isEmpty()) {
            return this.results.get(0);
        }
        return null;
    }

    public RequestResponseOK<T> setQuery(JsonNode query) {
        if (query != null) {
            this.query = query;
        }
        return this;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public static RequestResponseOK<JsonNode> getFromJsonNode(JsonNode node) throws InvalidParseOperationException {
        return (RequestResponseOK)JsonHandler.getFromString(node.toString(), RequestResponseOK.class, JsonNode.class);
    }

    public static <T> RequestResponseOK<T> getFromJsonNode(JsonNode node, Class<T> clazz) throws InvalidParseOperationException {
        return (RequestResponseOK)JsonHandler.getFromString(node.toString(), RequestResponseOK.class, clazz);
    }

    @JsonIgnore
    public List<JsonNode> getResultsAsJsonNodes() throws InvalidParseOperationException {
        if (this.results != null) {
            ArrayList<JsonNode> jsonNodeResults = new ArrayList<JsonNode>();
            for (T result : this.results) {
                jsonNodeResults.add(JsonHandler.toJsonNode(result));
            }
            return jsonNodeResults;
        }
        return null;
    }

    @Override
    public RequestResponseOK<T> setHttpCode(int httpCode) {
        super.setHttpCode(httpCode);
        return this;
    }

    @Override
    public Response toResponse() {
        Response.ResponseBuilder resp = Response.status((int)this.getStatus()).entity((Object)JsonHandler.unprettyPrint(this));
        Map<String, String> vitamHeaders = this.getVitamHeaders();
        for (String key : vitamHeaders.keySet()) {
            resp.header(key, (Object)this.getHeaderString(key));
        }
        this.unSetVitamHeaders();
        return resp.build();
    }
}

