/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;

public class ProbativeValueRequest {
    private static final String DSL_QUERY = "dslQuery";
    private static final String USAGE = "usage";
    private static final String VERSION = "version";
    private static final String INCLUDE_DETACHED_SIGNING_INFORMATION = "includeDetachedSigningInformation";
    private final JsonNode dslQuery;
    private final String usage;
    private final String version;
    private final Boolean includeDetachedSigningInformation;

    public ProbativeValueRequest(JsonNode dslQuery, String usage, String version) {
        this.dslQuery = Objects.requireNonNull(dslQuery);
        this.usage = Objects.requireNonNull(usage);
        this.version = Objects.requireNonNull(version);
        this.includeDetachedSigningInformation = null;
    }

    @JsonCreator
    public ProbativeValueRequest(@JsonProperty(value="dslQuery") JsonNode dslQuery, @JsonProperty(value="usage") String usage, @JsonProperty(value="version") String version, @JsonProperty(value="includeDetachedSigningInformation") boolean includeDetachedSigningInformation) {
        this.dslQuery = Objects.requireNonNull(dslQuery);
        this.usage = Objects.requireNonNull(usage);
        this.version = Objects.requireNonNull(version);
        this.includeDetachedSigningInformation = includeDetachedSigningInformation;
    }

    @JsonProperty(value="dslQuery")
    public JsonNode getDslQuery() {
        return this.dslQuery;
    }

    @JsonProperty(value="usage")
    public String getUsage() {
        return this.usage;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="includeDetachedSigningInformation")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIncludeDetachedSigningInformation() {
        return this.includeDetachedSigningInformation;
    }
}

