/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public class JsonLineIterator<T>
implements CloseableIterator<T> {
    private final InputStream inputStream;
    private final Class<T> clasz;
    private byte[] buffer;
    private int pos;
    private int available;
    private boolean eof;
    private boolean closed;

    private JsonLineIterator(InputStream inputStream, Class<T> clasz) {
        this.inputStream = inputStream;
        this.buffer = new byte[8192];
        this.pos = 0;
        this.available = 0;
        this.eof = false;
        this.closed = false;
        this.clasz = clasz;
    }

    public static <T> JsonLineIterator<T> parseFromResponse(Response response, Class<T> clasz) {
        return new JsonLineIterator<T>((InputStream)response.readEntity(InputStream.class), clasz);
    }

    @Override
    public boolean hasNext() {
        try {
            this.ensureLoaded();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return !this.eof;
    }

    private void ensureLoaded() throws IOException {
        if (this.closed) {
            throw new IOException("Attempt to read from closed stream");
        }
        if (this.eof) {
            return;
        }
        if (this.pos < this.available) {
            return;
        }
        int read = this.inputStream.read(this.buffer);
        if (read == -1) {
            this.eof = true;
            return;
        }
        this.available = read;
        this.pos = 0;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        InputStream lineInputStream = new InputStream(){
            boolean endOfLineStream = false;

            @Override
            public int read() throws IOException {
                byte nextChar;
                if (this.endOfLineStream) {
                    return -1;
                }
                JsonLineIterator.this.ensureLoaded();
                if (JsonLineIterator.this.eof) {
                    this.endOfLineStream = true;
                    return -1;
                }
                if ((nextChar = JsonLineIterator.this.buffer[JsonLineIterator.this.pos++]) == 10) {
                    this.endOfLineStream = true;
                    return -1;
                }
                return nextChar;
            }

            @Override
            public int read(@Nonnull byte[] buf) throws IOException {
                return this.read(buf, 0, buf.length);
            }

            @Override
            public int read(@Nonnull byte[] buf, int off, int len) throws IOException {
                int totalReadBytes;
                if (len == 0) {
                    return 0;
                }
                if (this.endOfLineStream) {
                    return -1;
                }
                JsonLineIterator.this.ensureLoaded();
                if (JsonLineIterator.this.eof) {
                    this.endOfLineStream = true;
                    return -1;
                }
                int writeOffset = off;
                for (totalReadBytes = 0; totalReadBytes < len && JsonLineIterator.this.pos < JsonLineIterator.this.available; ++totalReadBytes) {
                    byte nextChar;
                    if ((nextChar = JsonLineIterator.this.buffer[JsonLineIterator.this.pos++]) == 10) {
                        this.endOfLineStream = true;
                        break;
                    }
                    buf[writeOffset++] = nextChar;
                }
                return totalReadBytes;
            }

            @Override
            public void close() {
            }
        };
        try {
            InputStream remainingReadOnCloseInputStream = StreamUtils.getRemainingReadOnCloseInputStream(lineInputStream);
            return JsonHandler.getFromInputStream(remainingReadOnCloseInputStream, this.clasz);
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException("Could not parse json line entry", e);
        }
    }

    public void skip() {
        this.next();
    }

    @Override
    public void close() {
        try {
            this.buffer = null;
            this.closed = true;
            this.inputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close reader", e);
        }
    }

    private Spliterator<T> spliterator() {
        return Spliterators.spliteratorUnknownSize(this, 16);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

