/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.logging;

class FormattingTuple {
    private final String message;
    private final Throwable throwable;
    private final Object[] argArray;

    FormattingTuple(String message) {
        this(message, null, null);
    }

    FormattingTuple(String message, Object[] argArray, Throwable throwable) {
        this.message = message;
        this.throwable = throwable;
        this.argArray = throwable == null ? argArray : FormattingTuple.trimmedCopy(argArray);
    }

    static final Object[] trimmedCopy(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            throw new IllegalStateException("non-sensical empty or null argument array");
        }
        int trimemdLen = argArray.length - 1;
        Object[] trimmed = new Object[trimemdLen];
        System.arraycopy(argArray, 0, trimmed, 0, trimemdLen);
        return trimmed;
    }

    public final String getMessage() {
        return this.message;
    }

    public final Object[] getArgArray() {
        return this.argArray;
    }

    public final Throwable getThrowable() {
        return this.throwable;
    }
}

