/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class AbstractJsonType {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AbstractJsonType.class);

    public ObjectNode generateJson() {
        try {
            String value = JsonHandler.writeAsString(this);
            return (ObjectNode)JsonHandler.getFromString(value);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.warn("Cannot parse the Object", e);
            return JsonHandler.createObjectNode();
        }
    }

    public String generateJsonString() throws InvalidParseOperationException {
        return JsonHandler.writeAsString(this);
    }

    public void writeJsonToFile(File file) throws InvalidParseOperationException {
        ParametersChecker.checkParameter("File", file);
        JsonHandler.writeAsFile(this, file);
    }

    public static AbstractJsonType readJsonFile(File file) throws InvalidParseOperationException {
        ParametersChecker.checkParameter("File", file);
        return JsonHandler.getFromFile(file, AbstractJsonType.class);
    }

    public static AbstractJsonType readJsonString(String data) throws InvalidParseOperationException {
        ParametersChecker.checkParameterNullOnly("data", data);
        return JsonHandler.getFromString(data, AbstractJsonType.class);
    }
}

