/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.i18n;

import fr.gouv.vitam.common.CharsetUtils;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;

public class PluginPropertiesLoader {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PluginPropertiesLoader.class);
    static Map<String, String> resourceMap = new HashMap<String, String>();
    private static final String PLUGIN = "PLUGIN";

    private PluginPropertiesLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(String handlerID, String propertyFilename) {
        ParametersChecker.checkParameter("missing property file", propertyFilename);
        InputStream inputStream = null;
        try {
            inputStream = PropertiesUtils.getResourceAsStream(propertyFilename);
            if (null == inputStream) {
                return;
            }
            PropertyResourceBundle resourceBundle = new PropertyResourceBundle(new InputStreamReader(inputStream, CharsetUtils.UTF8));
            for (String key : resourceBundle.keySet()) {
                String value = resourceBundle.getString(key);
                resourceMap.put(key.replaceAll(PLUGIN, handlerID), value);
            }
        }
        catch (Exception e1) {
            LOGGER.debug("Exception occurs while load properties file (" + propertyFilename + "): ", e1);
        }
        finally {
            StreamUtils.closeSilently(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(String handlerID, String propertyFilename, ClassLoader urlClassLoader) {
        InputStream inputStream = null;
        try {
            inputStream = urlClassLoader.getResourceAsStream(propertyFilename);
            if (null == inputStream) {
                return;
            }
            PropertyResourceBundle resourceBundle = new PropertyResourceBundle(new InputStreamReader(inputStream, CharsetUtils.UTF8));
            for (String key : resourceBundle.keySet()) {
                String value = resourceBundle.getString(key);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Key : {} Value : {}", (Object)key, (Object)value);
                }
                resourceMap.put(key.replaceAll(PLUGIN, handlerID), value);
            }
        }
        catch (IOException e1) {
            LOGGER.error("Exception occurs while load properties file (" + propertyFilename + "): ", e1);
        }
        finally {
            StreamUtils.closeSilently(inputStream);
        }
    }

    public static final String getString(String message) {
        return resourceMap.get(message);
    }
}

