/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.guid;

import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.ServerIdentityInterface;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDImplPrivate;
import fr.gouv.vitam.common.guid.GUIDObjectType;

public final class GUIDFactory {
    private static final ServerIdentityInterface serverIdentity = ServerIdentity.getInstance();

    private GUIDFactory() {
    }

    public static final GUID newGUID() {
        return new GUIDImplPrivate(0, 0, serverIdentity.getGlobalPlatformId(), false);
    }

    static final GUID newChildrenGUID(GUID existingGUID) {
        return new GUIDImplPrivate(GUIDObjectType.getChildrenType(existingGUID.getObjectId()), existingGUID.getTenantId(), existingGUID.getPlatformId(), existingGUID.isWorm());
    }

    public static final GUID newUnitGUID(int tenantId) {
        boolean type = true;
        return new GUIDImplPrivate(1, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(1));
    }

    public static final GUID newObjectGroupGUID(int tenantId) {
        int type = 2;
        return new GUIDImplPrivate(2, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(2));
    }

    public static final GUID newObjectGroupGUID(GUID unitParentGUID) {
        int type = 2;
        return new GUIDImplPrivate(2, unitParentGUID.getTenantId(), serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(2));
    }

    public static final GUID newObjectGUID(int tenantId) {
        int type = 3;
        return new GUIDImplPrivate(3, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(3));
    }

    public static final GUID newObjectGUID(GUID objectGroupParentGUID) {
        int type = 3;
        return new GUIDImplPrivate(3, objectGroupParentGUID.getTenantId(), serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(3));
    }

    public static final GUID newOperationLogbookGUID(int tenantId) {
        int type = 4;
        return new GUIDImplPrivate(4, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(4));
    }

    public static final GUID newWriteLogbookGUID(int tenantId) {
        int type = 5;
        return new GUIDImplPrivate(5, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(5));
    }

    public static final GUID newStorageOperationGUID(int tenantId, boolean worm) {
        return new GUIDImplPrivate(9, tenantId, serverIdentity.getGlobalPlatformId(), worm);
    }

    public static final GUID newEventGUID(int tenantId) {
        int type = 7;
        return new GUIDImplPrivate(7, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(7));
    }

    public static final GUID newEventGUID(GUID logbookGUID) {
        int type = 7;
        return new GUIDImplPrivate(7, logbookGUID.getTenantId(), serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(7));
    }

    public static final GUID newRequestIdGUID(int tenantId) {
        int type = 8;
        return new GUIDImplPrivate(8, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(8));
    }

    public static final GUID newManifestGUID(int tenantId) {
        int type = 6;
        return new GUIDImplPrivate(6, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(6));
    }

    public static final GUID newAccessionRegisterSummaryGUID(int tenantId) {
        int type = 10;
        return new GUIDImplPrivate(10, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(10));
    }

    public static final GUID newAccessionRegisterSymbolicGUID(int tenantId) {
        int type = 10;
        return new GUIDImplPrivate(10, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(10));
    }

    public static final GUID newContractGUID(int tenantId) {
        int type = 11;
        return new GUIDImplPrivate(11, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(11));
    }

    public static final GUID newProfileGUID(int tenantId) {
        int type = 12;
        return new GUIDImplPrivate(12, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(12));
    }

    public static final GUID newOntologyGUID(int tenantId) {
        int type = 16;
        return new GUIDImplPrivate(16, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(16));
    }

    public static final GUID newContextGUID() {
        int type = 13;
        return new GUIDImplPrivate(13, 0, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(13));
    }

    public static final GUID newAgencyGUID(int tenantId) {
        int type = 15;
        return new GUIDImplPrivate(15, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(15));
    }

    public static final GUID newAccessionRegisterDetailGUID(int tenantId) {
        int type = 14;
        return new GUIDImplPrivate(14, tenantId, serverIdentity.getGlobalPlatformId(), GUIDObjectType.getDefaultWorm(14));
    }

    public static final boolean isWorm(GUID uuid) {
        return uuid.isWorm();
    }

    public static final int getKeysize() {
        return 22;
    }

    public static final int getKeysizeBase32() {
        return 36;
    }
}

