/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.error;

import fr.gouv.vitam.common.ParametersChecker;

public enum DomainName {
    TEST("00", "For test purpose ONLY"),
    IO("01", "Input / Output"),
    NETWORK("02", "Network"),
    ILLEGAL("03", "Illegal"),
    DATABASE("04", "Database"),
    STORAGE("05", "Storage"),
    BUSINESS("06", "Business"),
    SECURITY("07", "Security"),
    VALIDATION("08", "Validation");

    private final String code;
    private final String name;

    private DomainName(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static DomainName getFromCode(String code) {
        ParametersChecker.checkParameter("code is required", code);
        for (DomainName domain : DomainName.values()) {
            if (!domain.getCode().equals(code)) continue;
            return domain;
        }
        throw new IllegalArgumentException("Code {" + code + "} does not exist");
    }
}

