/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client;

import java.util.Objects;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public final class VitamContext {
    private Integer tenantId;
    private String accessContract;
    private String applicationSessionId;
    private String personalCertificate;

    public VitamContext(Integer tenantId) {
        this.tenantId = tenantId;
    }

    public Integer getTenantId() {
        return this.tenantId;
    }

    public VitamContext setTenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getAccessContract() {
        return this.accessContract;
    }

    public VitamContext setAccessContract(String accessContract) {
        this.accessContract = accessContract;
        return this;
    }

    public String getApplicationSessionId() {
        return this.applicationSessionId;
    }

    public VitamContext setApplicationSessionId(String applicationSessionId) {
        this.applicationSessionId = applicationSessionId;
        return this;
    }

    public String getPersonalCertificate() {
        return this.personalCertificate;
    }

    public VitamContext setPersonalCertificate(String personalCertificate) {
        this.personalCertificate = personalCertificate;
        return this;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        if (this.tenantId != null) {
            headers.add((Object)"X-Tenant-Id", (Object)this.tenantId);
        }
        if (this.accessContract != null) {
            headers.add((Object)"X-Access-Contract-Id", (Object)this.accessContract);
        }
        if (this.applicationSessionId != null) {
            headers.add((Object)"X-Application-Id", (Object)this.applicationSessionId);
        }
        if (this.personalCertificate != null) {
            headers.add((Object)"X-Personal-Certificate", (Object)this.personalCertificate);
        }
        return headers;
    }

    public String toString() {
        return "VitamContext{tenantId=" + this.tenantId + ", accessContract='" + this.accessContract + "', applicationSessionId='" + this.applicationSessionId + "', personalCertificate='" + this.personalCertificate + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VitamContext that = (VitamContext)o;
        return Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.accessContract, that.accessContract) && Objects.equals(this.applicationSessionId, that.applicationSessionId) && Objects.equals(this.personalCertificate, that.personalCertificate);
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.accessContract, this.applicationSessionId, this.personalCertificate);
    }
}

