/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client;

import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.io.input.ProxyInputStream;

public class VitamAutoClosableResponse
extends Response {
    private VitamAutoClosableResponseInputStream autoClosableResponseInputStream;
    private final Response response;
    private boolean isResponseClosed = false;

    public VitamAutoClosableResponse(Response response) {
        this.response = Objects.requireNonNull(response);
    }

    public void close() {
        if (this.autoClosableResponseInputStream != null && !this.autoClosableResponseInputStream.isClosed) {
            return;
        }
        if (!this.isResponseClosed) {
            StreamUtils.consumeAnyEntityAndClose(this.response);
            this.isResponseClosed = true;
        }
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public Response.StatusType getStatusInfo() {
        return this.response.getStatusInfo();
    }

    public Object getEntity() {
        Object entity = this.response.getEntity();
        return this.wrapInputStreamEntity(entity);
    }

    public <T> T readEntity(Class<T> entityType) {
        Object entity = this.response.readEntity(entityType);
        return (T)this.wrapInputStreamEntity(entity);
    }

    public <T> T readEntity(GenericType<T> entityType) {
        Object entity = this.response.readEntity(entityType);
        return (T)this.wrapInputStreamEntity(entity);
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        Object entity = this.response.readEntity(entityType, annotations);
        return (T)this.wrapInputStreamEntity(entity);
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        Object entity = this.response.readEntity(entityType, annotations);
        return (T)this.wrapInputStreamEntity(entity);
    }

    private <T> T wrapInputStreamEntity(T entity) {
        if (entity instanceof InputStream) {
            this.autoClosableResponseInputStream = new VitamAutoClosableResponseInputStream((InputStream)entity);
            return (T)((Object)this.autoClosableResponseInputStream);
        }
        return entity;
    }

    public boolean hasEntity() {
        return this.response.hasEntity();
    }

    public boolean bufferEntity() {
        return this.response.bufferEntity();
    }

    public MediaType getMediaType() {
        return this.response.getMediaType();
    }

    public Locale getLanguage() {
        return this.response.getLanguage();
    }

    public int getLength() {
        return this.response.getLength();
    }

    public Set<String> getAllowedMethods() {
        return this.response.getAllowedMethods();
    }

    public Map<String, NewCookie> getCookies() {
        return this.response.getCookies();
    }

    public EntityTag getEntityTag() {
        return this.response.getEntityTag();
    }

    public Date getDate() {
        return this.response.getDate();
    }

    public Date getLastModified() {
        return this.response.getLastModified();
    }

    public URI getLocation() {
        return this.response.getLocation();
    }

    public Set<Link> getLinks() {
        return this.response.getLinks();
    }

    public boolean hasLink(String relation) {
        return this.response.hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.response.getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        return this.response.getLinkBuilder(relation);
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.response.getMetadata();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.response.getStringHeaders();
    }

    public String getHeaderString(String name) {
        return this.response.getHeaderString(name);
    }

    private class VitamAutoClosableResponseInputStream
    extends ProxyInputStream {
        boolean isClosed;

        public VitamAutoClosableResponseInputStream(InputStream inputStream) {
            super(inputStream);
            this.isClosed = false;
        }

        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            StreamUtils.consumeAnyEntityAndClose(VitamAutoClosableResponse.this.response);
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

