/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InternalActionKeysRetriever {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(InternalActionKeysRetriever.class);
    private static final String INTERPUNCT = ".";
    private static final String ACTION = "$action";
    private static final String ACTION_KEY_SET = "$set";
    private static final String ACTION_KEY_UNSET = "$unset";
    private static final String ACTION_KEY_SETREGEX = "$setregex";
    private static final String ACTION_SETREGEX_KEY_TARGET = "$target";
    private final String internalPrefix;
    private final String internalPrefixFromAccess;
    private final String internalPrefixForMongo;

    public InternalActionKeysRetriever() {
        this("#", "_", "$");
    }

    @VisibleForTesting
    public InternalActionKeysRetriever(String internalPrefix, String internalPrefixFromAccess, String internalPrefixForMongo) {
        this.internalPrefix = internalPrefix;
        this.internalPrefixFromAccess = internalPrefixFromAccess;
        this.internalPrefixForMongo = internalPrefixForMongo;
    }

    public List<String> getInternalActionKeyFields(JsonNode query) {
        JsonNode action = query.get(ACTION);
        if (this.isElementEmpty(action)) {
            LOGGER.info("The action has no internal action key fields.");
            return Collections.emptyList();
        }
        return this.getActionKeyFields(action);
    }

    public List<String> getInternalKeyFields(JsonNode node) {
        return this.getSetUnsetKeys(node);
    }

    private List<String> getActionKeyFields(JsonNode node) {
        ArrayList<String> internalKeyFields = new ArrayList<String>();
        if (!node.isArray()) {
            LOGGER.info("The action has no internal action key fields.");
            return Collections.emptyList();
        }
        Iterator actionElements = node.elements();
        while (actionElements.hasNext()) {
            JsonNode actionElement = (JsonNode)actionElements.next();
            Iterator fields = actionElement.fields();
            while (fields.hasNext()) {
                internalKeyFields.addAll(this.getInternalActionKeyElementFields(fields));
            }
        }
        return internalKeyFields;
    }

    private List<String> getInternalActionKeyElementFields(Iterator<Map.Entry<String, JsonNode>> fields) {
        Map.Entry<String, JsonNode> field = fields.next();
        String key = field.getKey();
        if (ACTION_KEY_SET.equalsIgnoreCase(key) || ACTION_KEY_UNSET.equalsIgnoreCase(key)) {
            return this.getSetUnsetKeys(field.getValue());
        }
        if (key.equalsIgnoreCase(ACTION_KEY_SETREGEX)) {
            return this.getSetRegexTargetKey(field.getValue());
        }
        return Collections.emptyList();
    }

    private List<String> getSetRegexTargetKey(JsonNode node) {
        JsonNode element = node.get(ACTION_SETREGEX_KEY_TARGET);
        if (this.isElementEmpty(element)) {
            LOGGER.info("The $target element of $setregex action is empty.");
            return Collections.emptyList();
        }
        String value = element.textValue();
        if (this.isInternal(value)) {
            return Collections.singletonList(value);
        }
        return Collections.emptyList();
    }

    private boolean isElementEmpty(JsonNode element) {
        return element == null || element.isNull() || element.isMissingNode();
    }

    private List<String> getSetUnsetKeys(JsonNode node) {
        ArrayList<String> internalKeyFields = new ArrayList<String>();
        if (node.isObject()) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode value = (JsonNode)field.getValue();
                String key = (String)field.getKey();
                List<String> interpunctInternalKeyFields = this.interpunctInternalKeyFields(key);
                internalKeyFields.addAll(interpunctInternalKeyFields);
                if (this.isInternal(key)) {
                    internalKeyFields.add(key);
                }
                if (!value.isObject() && !value.isArray()) continue;
                internalKeyFields.addAll(this.getSetUnsetKeys(value));
            }
        }
        if (node.isArray()) {
            Iterator elements = node.elements();
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                if (!element.isObject() && !element.isArray()) continue;
                internalKeyFields.addAll(this.getSetUnsetKeys(element));
            }
        }
        return internalKeyFields;
    }

    private List<String> interpunctInternalKeyFields(String interpunctKey) {
        if (!interpunctKey.contains(INTERPUNCT)) {
            return Collections.emptyList();
        }
        List<String> interpuctKeyFields = Arrays.asList(interpunctKey.split("[.]"));
        if (interpuctKeyFields.isEmpty()) {
            return Collections.emptyList();
        }
        return interpuctKeyFields.stream().filter(this::isInternal).collect(Collectors.toList());
    }

    private boolean isInternal(String key) {
        return key.startsWith(this.internalPrefix) || key.startsWith(this.internalPrefixFromAccess) || key.startsWith(this.internalPrefixForMongo);
    }
}

