/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;

public class OntologyStep
extends CommonStep {
    private Path fileName;
    private OntologyModel ontologyModel;

    public OntologyStep(World world) {
        super(world);
    }

    @Given(value="^un fichier ontologie nomm\u00e9 (.*)$")
    public void setFileName(String fileName) {
        this.fileName = Paths.get(this.world.getBaseDirectory(), fileName);
    }

    @When(value="^j'importe l'ontologie$")
    public void importOntology() throws InvalidParseOperationException, AccessExternalClientException, IOException {
        this.importOntology(false);
    }

    @When(value="^j'importe l'ontologie en mode forc\u00e9$")
    public void forceImportOntology() throws InvalidParseOperationException, AccessExternalClientException, IOException {
        this.importOntology(true);
    }

    private void importOntology(boolean forceUpdate) throws IOException, InvalidParseOperationException, AccessExternalClientException {
        try (InputStream inputStream = Files.newInputStream(this.fileName, StandardOpenOption.READ);){
            VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
            vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
            RequestResponse requestResponse = this.world.getAdminClient().importOntologies(forceUpdate, vitamContext, inputStream);
            String operationId = requestResponse.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
            String httpCode = String.valueOf(requestResponse.getHttpCode());
            ObjectNode responseCode = JsonHandler.createObjectNode();
            responseCode.put("Code", httpCode);
            ArrayList<JsonNode> result = new ArrayList<JsonNode>();
            result.add((JsonNode)responseCode);
            this.world.setResults(result);
        }
    }

    @When(value="^je recherche le vocabulaire intitul\u00e9 (.*)$")
    public void searchOntologyByIdentifier(String identifier) throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse requestResponse = this.world.getAdminClient().findOntologyById(vitamContext, identifier);
        Assertions.assertThat((boolean)requestResponse.isOk()).isTrue();
        this.ontologyModel = (OntologyModel)((RequestResponseOK)requestResponse).getFirstResult();
    }

    @Then(value="^le type du vocabulaire est (.*)$")
    public void ontology_type_is(String type) {
        Assertions.assertThat((String)this.ontologyModel.getType().name()).isEqualTo(type);
    }

    @Then(value="^le type d\u00e9taill\u00e9 du vocabulaire est (.*)$")
    public void ontology_type_detail_is(String typeDetail) {
        Assertions.assertThat((String)this.ontologyModel.getTypeDetail().name()).isEqualTo(typeDetail);
    }

    @Then(value="^la taille de la cha\u00eene de caract\u00e8re du vocabulaire est (.*)$")
    public void ontology_string_size_is(String stringSize) {
        if ("ind\u00e9finie".equals(stringSize)) {
            Assertions.assertThat((Comparable)this.ontologyModel.getStringSize()).isNull();
        } else {
            Assertions.assertThat((String)this.ontologyModel.getStringSize().name()).isEqualTo(stringSize);
        }
    }
}

