/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import fr.gouv.vitam.logbook.common.model.TenantLogbookOperationTraceabilityResult;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import io.cucumber.java.en.When;
import java.util.Collections;
import java.util.concurrent.CompletionException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class LogbookInternalStep
extends CommonStep {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookInternalStep.class);

    public LogbookInternalStep(World world) {
        super(world);
    }

    @When(value="^je g\u00e9n\u00e8re un journal des op\u00e9rations s\u00e9curis\u00e9")
    public void generate_secured_logbook() {
        this.runInVitamThread(() -> {
            try {
                String operationId;
                VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
                VitamThreadUtils.getVitamSession().setContractId(this.world.getContractId());
                RequestResponseOK response = this.world.getLogbookOperationsClient().traceability(Collections.singletonList(this.world.getTenantId()));
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.world.getTenantId()));
                if (response.getResults().isEmpty() || ((TenantLogbookOperationTraceabilityResult)response.getResults().get(0)).getOperationId() == null) {
                    LOGGER.info("no need to run traceability");
                    RequestResponse logbookResponse = this.world.getLogbookOperationsClient().getLastOperationByType("STP_OP_SECURISATION");
                    if (!logbookResponse.isOk()) {
                        Assertions.fail((String)"no traceability operation found");
                        return;
                    }
                    RequestResponseOK logbook = (RequestResponseOK)logbookResponse;
                    if (logbook.getFirstResult() == null) {
                        Assertions.fail((String)"no traceability operation found");
                        return;
                    }
                    operationId = ((JsonNode)logbook.getFirstResult()).get(VitamFieldsHelper.id()).asText();
                } else {
                    operationId = ((TenantLogbookOperationTraceabilityResult)response.getResults().get(0)).getOperationId();
                }
                this.world.setOperationId(operationId);
                ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    @When(value="^je g\u00e9n\u00e8re un journal des cycles de vie des unit\u00e9s archivistiques s\u00e9curis\u00e9")
    public void generate_secured_lfc_unit() {
        this.runInVitamThread(() -> {
            String operationId;
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.world.getTenantId()));
            RequestResponseOK response = this.world.getLogbookOperationsClient().traceabilityLfcUnit();
            if (response.getResults().isEmpty()) {
                LOGGER.info("no need to run traceability");
                RequestResponse logbookResponse = this.world.getLogbookOperationsClient().getLastOperationByType(Contexts.UNIT_LFC_TRACEABILITY.getEventType());
                if (!logbookResponse.isOk()) {
                    Assertions.fail((String)"no traceability operation found");
                    return;
                }
                RequestResponseOK logbook = (RequestResponseOK)logbookResponse;
                if (logbook.getFirstResult() == null) {
                    Assertions.fail((String)"no traceability operation found");
                    return;
                }
                operationId = ((JsonNode)logbook.getFirstResult()).get(VitamFieldsHelper.id()).asText();
            } else {
                this.checkTraceabilityLfcResponseOKOrWarn((RequestResponseOK<String>)response);
                operationId = (String)response.getResults().get(0);
            }
            this.world.setOperationId(operationId);
            ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
        });
    }

    @When(value="^je g\u00e9n\u00e8re un journal des cycles de vie des groupes d'objets s\u00e9curis\u00e9")
    public void generate_secured_lfc_objectgroup() {
        this.runInVitamThread(() -> {
            String operationId;
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.world.getTenantId()));
            RequestResponseOK response = this.world.getLogbookOperationsClient().traceabilityLfcObjectGroup();
            if (response.getResults().isEmpty()) {
                LOGGER.info("no need to run traceability");
                RequestResponse logbookResponse = this.world.getLogbookOperationsClient().getLastOperationByType(Contexts.OBJECTGROUP_LFC_TRACEABILITY.getEventType());
                if (!logbookResponse.isOk()) {
                    Assertions.fail((String)"no traceability operation found");
                    return;
                }
                RequestResponseOK logbook = (RequestResponseOK)logbookResponse;
                if (logbook.getFirstResult() == null) {
                    Assertions.fail((String)"no traceability operation found");
                    return;
                }
                operationId = ((JsonNode)logbook.getFirstResult()).get(VitamFieldsHelper.id()).asText();
            } else {
                this.checkTraceabilityLfcResponseOKOrWarn((RequestResponseOK<String>)response);
                operationId = (String)response.getResults().get(0);
            }
            this.world.setOperationId(operationId);
            ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
        });
    }

    private void checkTraceabilityLfcResponseOKOrWarn(RequestResponseOK<String> requestResponseOK) throws VitamException {
        Assertions.assertThat((boolean)requestResponseOK.isOk()).isTrue();
        String traceabilityOperationId = requestResponseOK.getHeaderString("X-Request-Id");
        this.checkOperationStatus(traceabilityOperationId, StatusCode.OK, StatusCode.WARNING);
    }
}

