/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.export.dip.DipRequest;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import fr.gouv.vitam.functionaltest.models.UnitModel;
import io.cucumber.java.After;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerException;
import net.javacrumbs.jsonunit.JsonAssert;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.commons.collections4.list.TreeList;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class DipStep
extends CommonStep {
    private static final String EXPECTED_MANIFEST_START_WITH_SEDA_VERSION = "<?xml version=\"1.0\" ?><ArchiveDeliveryRequestReply xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:pr=\"info:lc/xmlns/premis-v2\" xmlns=\"%s\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"%s %s\"";
    private static final List<String> IGNORED_UNIT_FIELDS = List.of("id", "ArchiveUnitRefId", "DataObjectReference", "Event", "SignedObjectId");
    private static final List<String> IGNORED_GOT_FIELDS = List.of("id", "DataObjectVersion", "DataObjectGroupId", "Uri", "DataObjectProfile", "Filename", "LogBook");

    public DipStep(World world) {
        super(world);
    }

    @When(value="^j'exporte le dip$")
    public void exportDip() throws VitamException {
        this.cleanTempDipFile();
        VitamContext vitamContext = this.initContext();
        String query = this.world.getQuery();
        JsonNode jsonNode = JsonHandler.getFromString((String)query);
        DipRequest dipExportRequest = new DipRequest(jsonNode);
        RequestResponse response = this.world.getAdminClientV2().exportDIP(vitamContext, dipExportRequest);
        this.checkExportDipResponse((RequestResponse<JsonNode>)response);
    }

    @When(value="^j'exporte le DIP$")
    public void exportDIP() throws VitamException {
        this.cleanTempDipFile();
        VitamContext vitamContext = this.initContext();
        String query = this.world.getQuery();
        DipRequest dipExportRequest = (DipRequest)JsonHandler.getFromString((String)query, DipRequest.class);
        RequestResponse response = this.world.getAdminClientV2().exportDIP(vitamContext, dipExportRequest);
        this.checkExportDipResponse((RequestResponse<JsonNode>)response);
    }

    @When(value="^je t\u00e9l\u00e9charge le dip$")
    public void downloadDip() throws Exception {
        VitamContext vitamContext = this.initContext();
        Response response = this.world.getAccessClient().getDIPById(vitamContext, this.world.getOperationId());
        Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
        File tempFile = Files.createTempFile("DIP-" + this.world.getOperationId(), ".zip", new FileAttribute[0]).toFile();
        try (InputStream dipInputStream = (InputStream)response.readEntity(InputStream.class);){
            Files.copy(dipInputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        response.close();
        this.world.setDipFile(tempFile.toPath());
    }

    @When(value="^j'exporte le dip avec la version SEDA \"([^\"]*)\"")
    public void exportDipBySedaVersion(String sedaVersion) throws VitamException {
        this.cleanTempDipFile();
        VitamContext vitamContext = this.initContext();
        String query = this.world.getQuery();
        JsonNode jsonNode = JsonHandler.getFromString((String)query);
        DipRequest dipExportRequest = new DipRequest(jsonNode);
        dipExportRequest.setSedaVersion(sedaVersion);
        RequestResponse response = this.world.getAdminClientV2().exportDIP(vitamContext, dipExportRequest);
        this.checkExportDipResponse((RequestResponse<JsonNode>)response);
    }

    @Then(value="^le dip contient (\\d+) unit\u00e9s archivistiques$")
    public void checkDipUnitCount(int nbUnits) throws Exception {
        try (ZipFile zipFile = new ZipFile(this.world.getDipFile().toFile());){
            ZipArchiveEntry manifest = zipFile.getEntry("manifest.xml");
            try (InputStream is = zipFile.getInputStream(manifest);){
                int cpt = this.countElements(is, "ArchiveDeliveryRequestReply/DataObjectPackage/DescriptiveMetadata/ArchiveUnit");
                Assertions.assertThat((int)cpt).isEqualTo(nbUnits);
            }
        }
    }

    @Then(value="^le dip contient (\\d+) groupes d'objets$")
    public void checkDipObjectGroupCount(int nbObjectGroups) throws Exception {
        try (ZipFile zipFile = new ZipFile(this.world.getDipFile().toFile());){
            ZipArchiveEntry manifest = zipFile.getEntry("manifest.xml");
            try (InputStream is = zipFile.getInputStream(manifest);){
                int cpt = this.countElements(is, "ArchiveDeliveryRequestReply/DataObjectPackage/DataObjectGroup");
                Assertions.assertThat((int)cpt).isEqualTo(nbObjectGroups);
            }
        }
    }

    @Then(value="^le dip contient (\\d+) objets dont (\\d+) sont binaires$")
    public void checkDipObjectCount(int nbObjects, int nbBinaryObjects) throws Exception {
        try (ZipFile zipFile = new ZipFile(this.world.getDipFile().toFile());){
            ZipArchiveEntry manifest = zipFile.getEntry("manifest.xml");
            try (InputStream is = zipFile.getInputStream(manifest);){
                int cpt = this.countElements(is, "ArchiveDeliveryRequestReply/DataObjectPackage/DataObjectGroup/BinaryDataObject");
                Assertions.assertThat((int)cpt).isEqualTo(nbObjects);
            }
            ArrayList entries = Collections.list(zipFile.getEntries());
            long binaryFiles = entries.stream().filter(entry -> entry.getName().startsWith("Content/")).count();
            Assertions.assertThat((long)binaryFiles).isEqualTo((long)nbBinaryObjects);
        }
    }

    @Then(value="^le dip utilise la version SEDA \"([^\"]*)\"$")
    public void checkDipSedaVerion(String sedaVersion) throws Exception {
        try (ZipFile zipFile = new ZipFile(this.world.getDipFile().toFile());){
            String manifest;
            ZipArchiveEntry manifestEntry = zipFile.getEntry("manifest.xml");
            try (InputStream is = zipFile.getInputStream(manifestEntry);){
                manifest = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
            Optional supportedSedaVersion = SupportedSedaVersions.getSupportedSedaVersionByVersion((String)sedaVersion);
            Assertions.assertThat((boolean)supportedSedaVersion.isPresent()).isTrue();
            Assertions.assertThat((String)manifest).contains(new CharSequence[]{String.format(EXPECTED_MANIFEST_START_WITH_SEDA_VERSION, ((SupportedSedaVersions)supportedSedaVersion.get()).getNamespaceURI(), ((SupportedSedaVersions)supportedSedaVersion.get()).getNamespaceURI(), ((SupportedSedaVersions)supportedSedaVersion.get()).getSedaValidatorXSD())});
        }
    }

    @Then(value="le SIP et le DIP sont semblables")
    public void compareSipAndDip() throws Exception {
        String sipManifest = this.transform(this.getManifestFromZip(this.world.getSipFile()));
        String dipManifest = this.transform(this.getManifestFromZip(this.world.getDipFile()));
        XmlMapper xmlMapper = new XmlMapper();
        JsonNode sip = (JsonNode)xmlMapper.readValue(sipManifest, JsonNode.class);
        JsonNode dip = (JsonNode)xmlMapper.readValue(dipManifest, JsonNode.class);
        JsonNode gots = sip.at("/DataObjectPackage/DataObjectGroup");
        JsonNode gotsDip = dip.at("/DataObjectPackage/DataObjectGroup");
        JsonNode units = sip.at("/DataObjectPackage/DescriptiveMetadata/ArchiveUnit");
        JsonNode unitsDip = dip.at("/DataObjectPackage/DescriptiveMetadata/ArchiveUnit");
        ArrayNode SipGotsFiltred = this.filterGots(gots);
        ArrayNode DipGotsFiltred = this.filterGots(gotsDip);
        this.purgeIgnoredFields((JsonNode)SipGotsFiltred, IGNORED_GOT_FIELDS);
        this.purgeIgnoredFields((JsonNode)DipGotsFiltred, IGNORED_GOT_FIELDS);
        this.assertEqualsGotsJson((JsonNode)SipGotsFiltred, (JsonNode)DipGotsFiltred);
        this.purgeIgnoredFields(units, IGNORED_UNIT_FIELDS);
        this.purgeIgnoredFields(unitsDip, IGNORED_UNIT_FIELDS);
        DipStep.assertEqualsUnitsJson(units, unitsDip);
    }

    private static void assertEqualsUnitsJson(JsonNode expectedUnits, JsonNode value) throws Exception {
        List<UnitModel> listExpectedUnits = DipStep.sortUnitJson(expectedUnits);
        List<UnitModel> listRealUnits = DipStep.sortUnitJson(value);
        JsonAssert.assertJsonEquals((Object)JsonHandler.toJsonNode(listExpectedUnits), (Object)JsonHandler.toJsonNode(listRealUnits), (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]));
    }

    private void assertEqualsGotsJson(JsonNode expectedGots, JsonNode value) {
        JsonAssert.assertJsonEquals((Object)expectedGots, (Object)value, (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]));
    }

    private ArrayNode filterGots(JsonNode gots) {
        ArrayNode listGots = JsonHandler.createArrayNode();
        if (gots.isArray()) {
            for (int i = 0; i < gots.size(); ++i) {
                JsonNode got = gots.get(i);
                JsonNode binaryDataObject = got.get("BinaryDataObject");
                if (binaryDataObject.isArray()) {
                    ArrayNode objects = (ArrayNode)binaryDataObject;
                    for (int j = 0; j < objects.size(); ++j) {
                        JsonNode object = objects.get(j);
                        if (!object.get("DataObjectVersion").asText().startsWith("BinaryMaster")) continue;
                        listGots.add(object);
                    }
                    ((ArrayNode)gots).set(i, (JsonNode)objects);
                    continue;
                }
                if (!binaryDataObject.get("DataObjectVersion").asText().startsWith("BinaryMaster")) continue;
                listGots.add(binaryDataObject);
            }
        } else {
            listGots.add(gots);
        }
        return listGots;
    }

    private void purgeIgnoredFields(JsonNode jsonNode, List<String> ignoredFields) {
        if (jsonNode.isValueNode()) {
            return;
        }
        if (jsonNode.isArray()) {
            for (int i = 0; i < jsonNode.size(); ++i) {
                this.purgeIgnoredFields(jsonNode.get(i), ignoredFields);
            }
            return;
        }
        if (jsonNode.isObject()) {
            ((ObjectNode)jsonNode).remove(ignoredFields);
            for (JsonNode node : jsonNode) {
                this.purgeIgnoredFields(node, ignoredFields);
            }
            return;
        }
        throw new IllegalStateException("Unknown type " + String.valueOf(jsonNode));
    }

    private String transform(InputStream manifestInputStream) throws FileNotFoundException, TransformerException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SecureXMLFactoryUtils.xsltTransform((InputStream)PropertiesUtils.getResourceAsStream((String)"transform.xsl"), (InputStream)manifestInputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toString(StandardCharsets.UTF_8);
    }

    private InputStream getManifestFromZip(Path zip) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip.toFile());){
            ByteArrayInputStream byteArrayInputStream;
            block11: {
                ZipArchiveEntry manifest = zipFile.getEntry("manifest.xml");
                InputStream is = zipFile.getInputStream(manifest);
                try {
                    byteArrayInputStream = new ByteArrayInputStream(is.readAllBytes());
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return byteArrayInputStream;
        }
    }

    private int countElements(InputStream inputStream, String path) throws XMLStreamException {
        int cpt = 0;
        Stack<String> elementNames = new Stack<String>();
        XMLEventReader eventReader = SecureXMLFactoryUtils.createSecureXMLEventReader((InputStream)inputStream);
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            switch (event.getEventType()) {
                case 1: {
                    StartElement startElement = event.asStartElement();
                    String qName = startElement.getName().getLocalPart();
                    elementNames.add(qName);
                    String fullElementName = String.join((CharSequence)"/", elementNames);
                    if (!fullElementName.equals(path)) break;
                    ++cpt;
                    break;
                }
                case 2: {
                    elementNames.pop();
                }
            }
        }
        return cpt;
    }

    @After
    public void afterScenario() {
        this.cleanTempDipFile();
    }

    private void cleanTempDipFile() {
        if (this.world.getDipFile() != null) {
            FileUtils.deleteQuietly((File)this.world.getDipFile().toFile());
            this.world.setDipFile(null);
        }
    }

    private VitamContext initContext() {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        vitamContext.setAccessContract(this.world.getContractId());
        return vitamContext;
    }

    private void checkExportDipResponse(RequestResponse<JsonNode> response) throws VitamException {
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean processTimeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Assertions.fail((String)"dip processing not finished. Timeout exceeded.");
        }
        ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
    }

    private static List<UnitModel> sortUnitJson(JsonNode expectedUnits) throws InvalidParseOperationException {
        List listExpectedUnits = (List)JsonHandler.getFromJsonNode((JsonNode)expectedUnits, TreeList.class, UnitModel.class);
        listExpectedUnits.sort(UnitModel.UNIT_MODEL_COMPARATOR);
        return listExpectedUnits;
    }
}

